if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SPCG_DATIFATTURE]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SPCG_DATIFATTURE]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE dbo.SPCG_DATIFATTURE
(
	@CodiceDitta							int,					-- Codice azienda (se multiattivit in multiazienda = azienda principale)
	@Anno									smallint,				-- Anno di riferimento
	@Mese									tinyint,				-- Mese riferimento: 0 = Nessuno (tipo periodo: Annuale), 1/2/3/4/5/6/7/8/9/10/11/12 = Mesi (tipo periodo: Mensile), 3/6/9/12 = Trimestre (tipo periodo: Trimestrale), 6/12 = Semestre (tipo periodo: Semestrale)
	@IndPeriodo								tinyint, 				-- Indicatore tipo periodo: 0 = Annuale, 1 = Mensile, 2 = Trimestrale, 3 = Semestrale
	@MaxFattureFile							int = 0,				-- Limite massimo fatture per file
	@IndNumDocDTE							tinyint = 0,			-- Num. doc. fatture emesse: 0 = Numero documento origine, 1 = Numero protocollo
	@IndNumDocDTR							tinyint = 0,			-- Num. doc. fatture ricevute: 0 = Numero documento origine, 1 = Numero protocollo
	@DataInizio								datetime = null,		-- Data inizio elaborazione
	@DataFine								datetime = null,		-- Data fine elaborazione
	@PartitaIVANonRaggr						nvarchar(4000) = null,	-- Eleco partite IVA da non raggruppare
	@InserisciLetteraNumDoc					tinyint = 0,			-- Num. doc. fatture emesse: 0 = lascia il numero documento invariato, 1 = aggiunge una lettera se esiste lo stesso numero documento
	@InserisciLetteraMultiAtt				tinyint = 0,			-- Num. doc. fatture emesse: 0 = lascia il numero documento invariato, 1 = aggiunge una lettera per identificare aziende in multiattivit
	@IndTransfrontalieri					tinyint = 0				-- Filtro transfrontalieri: 0 = tutte le operazioni, 1 = solo operazioni transfrontaliere
)
AS
BEGIN
	SET NOCOUNT ON
	
	SET DATEFORMAT dmy
	
	declare @N								nvarchar(max) = cast('' as nvarchar(max))
	declare @StrSql1						nvarchar(max)
	declare @StrSql2						nvarchar(max)
	declare @StrSql3						nvarchar(max)
	declare @StrSql4						nvarchar(max)
	declare @StrSql5						nvarchar(max)

	declare @NomeTabellaTmpCG16				nvarchar(max)

	declare @DitteColl						nvarchar(max)
	declare @StrSqlDitteColl				nvarchar(max)
	declare @DataDitteColl					datetime
	declare @CodDittaPrincipale				decimal(5)
	declare @CodDittaCollegata				decimal(5)
	
	declare @IndProv						tinyint					--Indicatore provenienza: 0 = Manuale (standalone), 1 = Importazione, 2 = Telematico (elaborazione dati manuali, importati e da prima nota)
	declare @DataInizioComunicazione		nvarchar(8)
	declare @DataFineComunicazione			nvarchar(8)
	declare @DataInizioElaborazione			nvarchar(8)
	declare @DataFineElaborazione			nvarchar(8)
	declare @Cr								nchar(2)

	declare @CG3Q_ID						bigint
	declare @CG3S_PROGFLUSSO				int
	declare @CG3S_ID						bigint
	declare @CG3T_PROGFILE					int
	declare @CG3T_ID						bigint
	declare @IsAggiornaRec					tinyint
	declare @MaxCliFor						int
	declare @MaxFattureCF					int
	declare @IndTipoRec						smallint

	declare @StatoCampioneItalia			smallint
	declare @ComuneLivigno					nchar(4)

	if @IndPeriodo = 0 --Annuale
	begin
		set @DataInizioComunicazione = right('0000' + cast(@Anno as nvarchar(4)),4) + '0101'
		set @DataFineComunicazione = right('0000' + cast(@Anno as nvarchar(4)),4) + '1231'
	end
	else
		if @IndPeriodo = 1 --Mensile
		begin
			set @DataInizioComunicazione = right('0000' + cast(@Anno as nvarchar(4)),4) + right('00' + cast(@Mese as nvarchar(2)),2) + '01'
			set @DataFineComunicazione = right('0000' + cast(@Anno as nvarchar(4)),4) + right('00' + cast(@Mese as nvarchar(2)),2) + right('00' + cast(day(dateadd(day,-1,dateadd(month,1,@DataInizioComunicazione))) as nvarchar(2)),2)
		end
		else
			if @IndPeriodo = 2 --Trimestrale
			begin
				set @DataInizioComunicazione = right('0000' + cast(@Anno as nvarchar(4)),4) + right('00' + cast(@Mese-2 as nvarchar(2)),2) + '01'
				set @DataFineComunicazione = right('0000' + cast(@Anno as nvarchar(4)),4) + right('00' + cast(@Mese as nvarchar(2)),2) + right('00' + cast(day(dateadd(day,-1,dateadd(month,3,@DataInizioComunicazione))) as nvarchar(2)),2)
			end
				if @IndPeriodo = 3 --Semestrale
				begin
					set @DataInizioComunicazione = right('0000' + cast(@Anno as nvarchar(4)),4) + right('00' + cast(@Mese-5 as nvarchar(2)),2) + '01'
					set @DataFineComunicazione = right('0000' + cast(@Anno as nvarchar(4)),4) + right('00' + cast(@Mese as nvarchar(2)),2) + right('00' + cast(day(dateadd(day,-1,dateadd(month,6,@DataInizioComunicazione))) as nvarchar(2)),2)
				end

	if IsDate(@DataInizio) = 0
		set @DataInizioElaborazione =  @DataInizioComunicazione
	else
		set @DataInizioElaborazione =  right('0000' + cast(year(@DataInizio) as nvarchar(4)),4) + right('00' + cast(month(@DataInizio) as nvarchar(2)),2) + right('00' + cast(day(@DataInizio) as nvarchar(2)),2)

	if IsDate(@DataFine) = 0
		set @DataFineElaborazione =  @DataFineComunicazione
	else
		set @DataFineElaborazione =  right('0000' + cast(year(@DataFine) as nvarchar(4)),4) + right('00' + cast(month(@DataFine) as nvarchar(2)),2) + right('00' + cast(day(@DataFine) as nvarchar(2)),2)

	
	if IsDate(@DataInizioComunicazione) = 0 or
	   IsDate(@DataFineComunicazione) = 0 or 
	   IsDate(@DataInizioElaborazione) = 0 or 
	   IsDate(@DataFineElaborazione) = 0
		return

	set @IndProv = 2 --Telematico
	set @Cr = char(13) --Carriage Return
	set @NomeTabellaTmpCG16 = '#CG16_OMONIMI'

	set @PartitaIVANonRaggr = replace(isnull(@PartitaIVANonRaggr,''),',',''',''')

	set @MaxCliFor = 1000
	set @MaxFattureCF = 1000

	if isnull(@MaxFattureFile,0) = 0
		set @MaxFattureFile = 8000
	
	set @IndNumDocDTE = isnull(@IndNumDocDTE,0)
	set @IndNumDocDTR = isnull(@IndNumDocDTR,0)

	set @StatoCampioneItalia = 139
	set @ComuneLivigno = 'E621'
	
	set @CodDittaPrincipale = @CodiceDitta
	set @CodDittaCollegata = @CodiceDitta
	set @DataDitteColl = @DataInizioComunicazione
	
	exec PC_GetDitteCollegate @CodiceDitta,
							  @DataDitteColl,
							  0,0,0,Null,Null,Null,
							  @DitteColl output,
							  @StrSqlDitteColl output, 1

	if isnull(@DitteColl,'') <> '' 
	begin
		set @StrSql1 = @N + 
					  'SELECT @CodDittaPrincipaleOut = DITTA FROM (' + @StrSqlDitteColl + ') AS DITTECOLL WHERE PRINCIPALE = 1'
		execute sp_executesql @StrSql1, N'@CodDittaPrincipaleOut decimal(5) OUTPUT', @CodDittaPrincipaleOut = @CodDittaPrincipale OUTPUT
	end
	else
	begin
		set @DitteColl = @CodiceDitta	
	end
	
	/**** IMPORTAZIONE MOVIMENTI PRIMA NOTA ****/
	
/*
		1-Acquisti
		2-Vendite
		3-Corrispettivi
		4-AcquistiMonteVentilazione
		6-SospesaAcquisti
		7-SospesaVendite
		8-SospesaCorrispettivi
	12-AcquistiIntra
	15-AcquistiCompetenzaMesePrecedente
	16-VenditeCompetenzaMesePrecedente
	18-VenditeConSubfornitura
	19-Editoria
	21-VenditeCompetenzaTrimestreSuccessivo
	30-RegimeDelMargineAnalitico
	31-RegimeDelMargineGlobale
	32-RegimeDelMargineForfetario25pc
	33-RegimeDelMargineForfetario50pc
	34-RegimeDelMargineForfetario60pc
	40-VenditaAutoUE
	50-AgricolturaAcquisti
	51-AgricolturaAcquistiAttivitaConnessa
	55-AgricolturaVendite
	56-AgricolturaVenditeAttivitaConnessa
	60-AgenzieViaggioVendite74TerUE
	61-AgenzieViaggioVendite74TerExtraUE
	62-AgenzieViaggioVendite74TerMisti
	63-AgenzieViaggioAcquisti74TerUE
	64-AgenzieViaggioAcquisti74TerExtraUE
	65-AgenzieViaggioAcquisti74TerMistiParteUE
	66-AgenzieViaggioAcquisti74TerMistiParteExtraUE
    85-AcquistiMonteVentilazione_SplitPayment
    86-Acquisti_SplitPayment
    88-SospesaVendite_SplitPayment
	90-SospesaAcquisti_AltreSocieta
	91-SospesaVendite_AltreSocieta
	92-SospesaCorrispettivi_AltreSocieta
	96-SospesaAcquistiMonteVentilazione_AltreSocieta
*/

	/* Creo la tabella temporanea CG16 con le anagrafiche ordinate per omonimi da utilizzare per ottimizzare la query */
	set @StrSql1 = @N + 
					' IF OBJECT_ID(N''tempdb..' + @NomeTabellaTmpCG16 + ''', N''U'') IS NOT NULL' + @Cr +
					'		DROP TABLE ' + @NomeTabellaTmpCG16 + @Cr +
					'' + @Cr +
					' SELECT CG16_FLGOMONIMO, CG16_CODICE, PARTIVA, CG16_CODFISCALE INTO ' + @NomeTabellaTmpCG16 + @Cr +
					' FROM (SELECT VCG16.CG16_FLGOMONIMO, VCG16.CG16_CODICE, VCG16.PARTIVA, VCG16.CG16_CODFISCALE' + @Cr +
					'		FROM VCG16_ANAGGENVALIDA AS VCG16' + @Cr +
					'		INNER JOIN CG16_ANAGGEN AS CG16' + @Cr +
					'		   ON CG16.CG16_CODICE = VCG16.CG16_CODICE' + @Cr +
					'		WHERE ''' + @DataFineComunicazione + ''' >= ISNULL(VCG16.DATAINIZIOVALIDITA, ''17530101'')' + @Cr +
					'		  AND ''' + @DataFineComunicazione + ''' <= ISNULL(VCG16.DATAFINEVALIDITA, ''99991231'')' + @Cr +
					'		  AND (CG16.CG16_CODRICHIAMO IS NULL' + @Cr +
					'			   OR (CG16.CG16_CODRICHIAMO IS NOT NULL AND CG16.CG16_DATAVALID > ''' + @DataFineComunicazione + ''')' + @Cr +
					'			   )' + @Cr +
					'		) AS VCG16' + @Cr +
					'' + @Cr +
					' INSERT INTO CG3R_DATIFATTURE (CG3R_DITTA_CG18, CG3R_ANNO, CG3R_MESE, CG3R_INDPERIODO, CG3R_INDPROV, CG3R_INDTIPOINVIO, CG3R_INDTIPOREC, CG3R_DITTACOLL_CG18, CG3R_TIPOCF_CG44, CG3R_CLIFOR_CG44, CG3R_CODICE_CG16, CG3R_NUMREG_CO99, CG3R_INDTIPODOC, CG3R_DATADOC, CG3R_NUMDOC, CG3R_DATAREG, CG3R_IMPORTO, CG3R_IMPOSTA, CG3R_PERCIVA, CG3R_INDNATURA, CG3R_PERCDETR, CG3R_INDDEDUC, CG3R_INDIVASOSP, CG3R_ID_CG3R, CG3R_NUMREGORI_CO99, CG3R_IDORI_CG3R, CG3R_ANAGRAPPFISC_CG16, CG3R_ANAGSTABORG_CG16)' + @Cr +
					' SELECT CG3R_DITTA_CG18, CG3R_ANNO, CG3R_MESE, CG3R_INDPERIODO, CG3R_INDPROV, CG3R_INDTIPOINVIO, CG3R_INDTIPOREC, CG3R_DITTACOLL_CG18, CG3R_TIPOCF_CG44, CG3R_CLIFOR_CG44, CG3R_CODICE_CG16, CG3R_NUMREG_CO99, CG3R_INDTIPODOC, CG3R_DATADOC, CG3R_NUMDOC, CG3R_DATAREG, CG3R_IMPORTO, CG3R_IMPOSTA, CG3R_PERCIVA, CG3R_INDNATURA, CG3R_PERCDETR, CG3R_INDDEDUC, CG3R_INDIVASOSP, CG3R_ID_CG3R, CG3R_NUMREG_CO99 AS CG3R_NUMREGORI_CO99, CG3R_ID_CG3R AS CG3R_IDORI_CG3R, CG3R_ANAGRAPPFISC_CG16, CG3R_ANAGSTABORG_CG16' + @Cr +
					' FROM (' + @Cr +
					' SELECT CG3R_DITTA_CG18, CG3R_ANNO, CG3R_MESE, CG3R_INDPERIODO, CG3R_INDPROV, CG3R_INDTIPOINVIO, CG3R_INDTIPOREC, CG3R_DITTACOLL_CG18, CG3R_TIPOCF_CG44, CG3R_CLIFOR_CG44, CG3R_CODICE_CG16,' + @Cr +
				    '        CASE CG3R_INDTIPOREC' + @Cr +
					'			  WHEN 1 THEN CASE WHEN LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.PARTIVA,''''))) = '''' AND ISNULL(CG07_TABSTATIEST.CG07_A2ISO3166, ISNULL(CG07_TABSTATIEST.CG07_CODISO,''IT'')) <> ''IT'' THEN LEFT(CAST(VCG16_ANAGGEN.CG16_CODICE AS NVARCHAR(10)) + '' '' + ISNULL(VCG16_ANAGGEN.RAGSOANAGPF,''''),28) ELSE VCG16_ANAGGEN.PARTIVA END' + @Cr +
					'             WHEN 2 THEN CASE WHEN LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.PARTIVA,''''))) = '''' AND ISNULL(CG07_TABSTATIEST.CG07_INDTIPOSTATO, -1) = 0 THEN LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.CG16_PARTIVA_EST,''''))) ELSE LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.PARTIVA,''''))) END' + @Cr +
					'             ELSE NULL' + @Cr +
					'             END AS PARTIVA,' + @Cr +
					'		 CASE WHEN ISNULL(CG07_TABSTATIEST.CG07_A2ISO3166, ISNULL(CG07_TABSTATIEST.CG07_CODISO,''IT'')) = ''IT'' THEN VCG16_ANAGGEN.CG16_CODFISCALE ELSE NULL END AS CG16_CODFISCALE,' + @Cr +
                    '        CASE WHEN CG3R_INDTIPODOC IN (7,8) AND LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.PARTIVA,''''))) = '''' AND LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.CG16_CODFISCALE,''''))) = ''''' + @Cr +
                    '             THEN LEFT(ISNULL(VCG16_ANAGGEN.RAGSOANAGPF,''''),80)' + @Cr +
                    '             ELSE CASE WHEN ISNULL(VCG16_ANAGGEN.RAGSOANAGPF,'''') <> ''''' + @Cr +
                    '                       THEN LEFT(ISNULL(VCG16_ANAGGEN.RAGSOANAGPF,''''),80)' + @Cr +
                    '                       ELSE ''''' + @Cr +
                    '                       END' + @Cr +
                    '             END AS CG16_RAGSOANAG,' + @Cr +
					'        CG3R_NUMREG_CO99, CG3R_INDTIPODOC, CG3R_DATADOC, CG3R_NUMDOC, CG3R_DATAREG, CG3R_IMPORTO, CG3R_IMPOSTA, CG3R_PERCIVA, CG3R_INDNATURA, CG3R_PERCDETR, CG3R_INDDEDUC, CG3R_INDIVASOSP, CG3R_ID_CG3R, CG3R_NUMREG_CO99 AS CG3R_NUMREGORI_CO99, CG3R_ID_CG3R AS CG3R_IDORI_CG3R, CG3R_ANAGRAPPFISC_CG16, CG3R_ANAGSTABORG_CG16' + @Cr +
					' FROM (' + @Cr +
					' SELECT ' + cast(@CodDittaPrincipale as nvarchar(5)) + ' AS CG3R_DITTA_CG18, ' + @Cr +
					'		 ' + cast(@Anno as nvarchar(4)) + ' AS CG3R_ANNO, ' + @Cr +
					'		 ' + cast(@Mese as nvarchar(2)) + ' AS CG3R_MESE, ' + @Cr +
					'		 ' + cast(@IndPeriodo as nvarchar(2)) + ' AS CG3R_INDPERIODO, ' + @Cr +
					'        ' + cast(@IndProv as nvarchar(2)) + ' AS CG3R_INDPROV,' + @Cr +
					'        0 AS CG3R_INDTIPOINVIO,' + @Cr +
					'		 INDTIPOREC AS CG3R_INDTIPOREC,' + @Cr +
					'        CG41_DITTA_CG18 AS CG3R_DITTACOLL_CG18, ' + @Cr +
 					'		 CG41_TIPOCF_CG44 AS CG3R_TIPOCF_CG44,' + @Cr +
 					'		 CG41_CLIFOR_CG44 AS CG3R_CLIFOR_CG44,' + @Cr +
					'		 CASE WHEN (PARTITAIVA IS NULL OR (PARTITAIVA IN (''' + @PartitaIVANonRaggr + ''') AND INDTIPOREC = 2)) AND CODFISCALE IS NULL' + @Cr +
					'			  THEN CODANAG' + @Cr +
					'			  ELSE ISNULL((SELECT TOP 1 CG16_CODICE' + @Cr +
					'						   FROM ' + @NomeTabellaTmpCG16 + ' AS VCG16' + @Cr +
					'						   WHERE ISNULL(VCG16.PARTIVA,'''') = ISNULL(PARTITAIVA,'''')' + @Cr +
					'							 AND ISNULL(VCG16.CG16_CODFISCALE,'''') = ISNULL(CODFISCALE,'''')' + @Cr +
					'						   ORDER BY VCG16.CG16_FLGOMONIMO DESC, VCG16.CG16_CODICE DESC' + @Cr +
					'				   ),CODANAG)' + @Cr +
					'			  END AS CG3R_CODICE_CG16,' + @Cr +
					'		 PARTITAIVA,' + @Cr +
					'		 CODFISCALE,' + @Cr +
 					'        CG41_NUMREG AS CG3R_NUMREG_CO99,' + @Cr +
 					'	     INDTIPODOC AS CG3R_INDTIPODOC,' + @Cr +
					'        ISNULL(CG41_DATADOC,CG41_DATAREG) AS CG3R_DATADOC,' + @Cr +
					'		 NUMDOC AS CG3R_NUMDOC,' + @Cr + 
					'        CG41_DATAREG AS CG3R_DATAREG,' + @Cr +
					'		 SUM(ISNULL(IMPONIBILE,0) + CASE WHEN INDTIPODOC IN (7,8) THEN ISNULL(IMPOSTA,0) ELSE 0 END) AS CG3R_IMPORTO,' + @Cr +
					'		 SUM(CASE WHEN INDTIPODOC IN (7,8) THEN NULL ELSE ISNULL(IMPOSTA,0) END) AS CG3R_IMPOSTA,' + @Cr +
					'		 CASE WHEN ISNULL(FLGIVANOESP,0) = 1 THEN 0 ELSE ISNULL(CG28_PERCIVA,0) END AS CG3R_PERCIVA,' + @Cr +
					'		 INDNATURA AS CG3R_INDNATURA,' + @Cr +
					'		 CG43_PERCDETR AS CG3R_PERCDETR,' + @Cr +
					'		 CG43_FLGDEDUCIBILE AS CG3R_INDDEDUC,' + @Cr +
					'		 INDIVASOSP AS CG3R_INDIVASOSP,' + @Cr +
					'		 NULL AS CG3R_ID_CG3R,' + @Cr +
					'		 CG41_ANAGRAPPFISC_CG16 AS CG3R_ANAGRAPPFISC_CG16,' + @Cr +
					'		 CG41_ANAGSTABORG_CG16 AS CG3R_ANAGSTABORG_CG16' + @Cr +
					' FROM (' + @Cr +
					' SELECT INDTIPOREC, CG41_DITTA_CG18, CG41_TIPOCF_CG44, CG41_CLIFOR_CG44, CODANAG, PARTITAIVA, CODFISCALE, CG41_NUMREG, INDTIPODOC, CG41_DATADOC, NUMDOC, CG41_DATAREG, FLGIVANOESP,' + @Cr +
					'		 IMPONIBILE, IMPOSTA, CG28_PERCIVA, INDNATURA, CG43_PERCDETR, CG43_FLGDEDUCIBILE, INDIVASOSP,' + @Cr +
					'		 CASE WHEN 0 = (SELECT SUM(ISNULL(CG43_IMPONIBILE,0) + ISNULL(CG43_IMPOSTA,0)) AS IMPORTO' + @Cr +
					'					    FROM CG43_MOVIVA AS CG43 WITH(NOLOCK)' + @Cr +
 					'						LEFT OUTER JOIN CG28_TABCODIVA AS CG28 WITH(NOLOCK)' + @Cr +
 					'						  ON CG28.CG28_CODICE = CG43.CG43_ALIQIVA1_CG28' + @Cr +
					'						WHERE CG43.CG43_DITTA_CG18 = PRIMANOTA.CG41_DITTA_CG18' + @Cr +
					'						  AND CG43.CG43_NUMREG_CG41 = PRIMANOTA.CG41_NUMREG' + @Cr +
					'						  AND ISNULL(CG28.CG28_PERCIVA,0) = ISNULL(PRIMANOTA.CG28_PERCIVA,0)' + @Cr +
					'						  AND ISNULL(CG43.CG43_PERCDETR,0) = ISNULL(PRIMANOTA.CG43_PERCDETR,0)' + @Cr +
					'						  AND CG43.CG43_FLGDEDUCIBILE = PRIMANOTA.CG43_FLGDEDUCIBILE' + @Cr +
					'						  AND CG28.CG28_FLGSOSPIMP = PRIMANOTA.CG28_FLGSOSPIMP' + @Cr +
					'					   ) AND INDNATURA IN (0,6)' + @Cr +
					'			  THEN PRIMANOTA.CG43_NUMRIGAIVA' + @Cr + 
					'			  ELSE 0' + @Cr +
					'			  END AS INDRAGGR,' + @Cr +
					'		 CG41_ANAGRAPPFISC_CG16,' + @Cr +
					'		 CG41_ANAGSTABORG_CG16' + @Cr +
					' FROM (' + @Cr +
					'		 SELECT CG41_DITTA_CG18, CG41_TIPOCF_CG44, ISNULL(CG4E.CG4E_CLIFORCO_CG44, CG41_CLIFOR_CG44) AS CG41_CLIFOR_CG44, CG41_NUMREG, CG41_DATADOC, CG41_DATAREG, NUMDOC,' + @Cr +
					'		 VCG16_ANAGGEN.CG16_CODICE AS CODANAG,' + @Cr +
					'		 VCG16_ANAGGEN.PARTIVA AS PARTITAIVA,' + @Cr +
					'		 VCG16_ANAGGEN.CG16_CODFISCALE AS CODFISCALE,' + @Cr +
					'		 CASE ISNULL(CG33_INDTIPOREG,0)' + @Cr +
					'			  WHEN 1 THEN 2' + @Cr +
					'			  WHEN 2 THEN 1' + @Cr +
					'		      ELSE 0' + @Cr +
					'			  END AS INDTIPOREC,' + @Cr
	set @StrSql2 = @N + 
					'		 CASE WHEN CG41_INDTIPODOC <> 0' + @Cr +
					'			  THEN CG41_INDTIPODOC' + @Cr +
					'			  ELSE CASE ISNULL(CG33_INDTIPOREG,0)' + @Cr +
		  			'						WHEN 1 THEN CASE WHEN ISNULL(CG41_FLGDOCRIEP,0) <> 0' + @Cr + --Fatture ricevute
					'										 THEN 12' + @Cr + --Documento riepilogativo
					'										 ELSE CASE WHEN ISNULL(CG07_TABSTATIEST.CG07_INDTIPOSTATO,-1) = 1 /*ISNULL(CG43_INDTIPO,0) = 12*/ AND ISNULL(NOTAVAR,0) = 0' + @Cr + --Documento non riepilogativo
					'												   THEN CASE WHEN ISNULL(SERVIZI,0) <> 0' + @Cr + --Intra acquisti
					'															 THEN 11' + @Cr + --Servizi
					'															 ELSE 10' + @Cr + --Beni
					'															 END' + @Cr +
					'												   ELSE CASE WHEN ISNULL(CG41_FLGDOCSEMPLIF,0) <> 0' + @Cr + --Non Intra (Nazionale, ExtraCEE, RSM)
					'															 THEN CASE WHEN ISNULL(NOTAVAR,0) <> 0' + @Cr + --Fattura semplificata
					'																	   THEN 8' + @Cr + --Nota credito semplificata
					'																	   ELSE 7' + @Cr + --Fattura semplificata
					'																	   END' + @Cr +
					'															 ELSE CASE WHEN ISNULL(NOTAVAR,0) <> 0' + @Cr + --Fattura NON semplificata
					'																	   THEN CASE WHEN ISNULL(NOTADEB,0) <> 0' + @Cr +
					'																				 THEN 5' + @Cr + --Nota debito
					'																				 ELSE 4' + @Cr + --Nota credito
					'																				 END' + @Cr +
					'																	   ELSE 1' + @Cr + --Fattura
					'																	   END' + @Cr +
					'															 END' + @Cr +
					'												  END' + @Cr +
					'										 END' + @Cr +
 					'						WHEN 2 THEN CASE WHEN ISNULL(CG41_FLGDOCRIEP,0) <> 0' + @Cr + --Fatture emesse
					'										 THEN 12' + @Cr + --Documento riepilogativo
					'										 ELSE CASE WHEN ISNULL(CG41_FLGDOCSEMPLIF,0) <> 0' + @Cr + --Documento non riepilogativo
					'												   THEN CASE WHEN ISNULL(NOTAVAR,0) <> 0' + @Cr + --Fattura semplificata
					'															 THEN 8' + @Cr + --Nota credito semplificata
					'															 ELSE 7' + @Cr + --Fattura semplificata
					'															 END' + @Cr +
					'												   ELSE CASE WHEN ISNULL(NOTAVAR,0) <> 0' + @Cr + --Fattura NON semplificata
					'															 THEN CASE WHEN ISNULL(NOTADEB,0) <> 0' + @Cr +
					'																	   THEN 5' + @Cr + --Nota debito
					'																	   ELSE 4' + @Cr + --Nota credito
					'																	   END' + @Cr +
					'															 ELSE 1' + @Cr + --Fattura
					'															 END' + @Cr +
					'												   END' + @Cr +
					'										 END' + @Cr +
 					'						ELSE 0' + @Cr +
					'						END' + @Cr +
 					'			  END AS INDTIPODOC,' + @Cr +
					'		 ISNULL(CAST(ROUND((ISNULL(IMPONIBILE,0) * CASE WHEN ISNULL(CG4E.CG4E_PERCENTUALE,0) = 0 THEN 1 ELSE ISNULL(CG4E.CG4E_PERCENTUALE,0)/100 END),2) AS DECIMAL(13,2)),0)' + @Cr +
					'		      + CASE WHEN MAX(ISNULL(CG4E.CG4E_CLIFORCO_CG44,0)) OVER(PARTITION BY CG4E.CG4E_DITTA_CG18, CG4E.CG4E_TIPOCF_CG44, CG4E.CG4E_CLIFOR_CG44) = CG4E.CG4E_CLIFORCO_CG44' + @Cr +
					'					 THEN (ISNULL(IMPONIBILE,0) - SUM(CAST(ROUND((ISNULL(IMPONIBILE,0) * CASE WHEN ISNULL(CG4E.CG4E_PERCENTUALE,0) = 0 THEN 1 ELSE ISNULL(CG4E.CG4E_PERCENTUALE,0)/100 END),2) AS DECIMAL(13,2))) OVER(PARTITION BY CG41_DITTA_CG18, CG41_NUMREG, CG43_NUMRIGAIVA))' + @Cr +
					'					 ELSE 0' + @Cr +
					'					 END AS IMPONIBILE,' + @Cr +
					'		 ISNULL(CAST(ROUND((ISNULL(IMPOSTA,0) * CASE WHEN ISNULL(CG4E.CG4E_PERCENTUALE,0) = 0 THEN 1 ELSE ISNULL(CG4E.CG4E_PERCENTUALE,0)/100 END),2) AS DECIMAL(13,2)),0)' + @Cr +
					'			  + CASE WHEN MAX(ISNULL(CG4E.CG4E_CLIFORCO_CG44,0)) OVER(PARTITION BY CG4E.CG4E_DITTA_CG18, CG4E.CG4E_TIPOCF_CG44, CG4E.CG4E_CLIFOR_CG44) = CG4E.CG4E_CLIFORCO_CG44' + @Cr +
					'					 THEN (ISNULL(IMPOSTA,0) - SUM(CAST(ROUND((ISNULL(IMPOSTA,0) *CASE WHEN ISNULL(CG4E.CG4E_PERCENTUALE,0) = 0 THEN 1 ELSE ISNULL(CG4E.CG4E_PERCENTUALE,0)/100 END),2) AS DECIMAL(13,2))) OVER(PARTITION BY CG41_DITTA_CG18, CG41_NUMREG, CG43_NUMRIGAIVA))' + @Cr +
					'					 ELSE 0' + @Cr +
					'					 END AS IMPOSTA,' + @Cr +
					'		 CG28_PERCIVA,' + @Cr +
					'		 CASE WHEN CG43_INDNATURA IS NOT NULL' + @Cr +
					'			  THEN CG43_INDNATURA' + @Cr +
					'			  ELSE CASE WHEN CG28_INDNATURA IS NOT NULL' + @Cr +
					'						THEN CG28_INDNATURA' + @Cr +
					'						ELSE CASE WHEN (ISNULL(CG33_INDTIPOREG,0) = 2 AND ISNULL(IMPOSTA,0) = 0) OR (ISNULL(CG33_INDTIPOREG,0) = 1)' + @Cr +
					'								  THEN CASE WHEN CG28_FLGMOSSGEST = 1' + @Cr +
					'											THEN 7' + @Cr + --N7 - IVA assolta in altro stato UE (MOSS)
					'											ELSE CASE WHEN (CG43_INDTIPO IN(14, 39, 87) AND CG41_RIFPADRE IS NOT NULL)' + @Cr +
					'														OR (LTRIM(RTRIM(ISNULL(CG33_CAUSALEIVA, CG33_CODICE))) IN(''41'',''42'',''51'',''52'',''96'',''97'') AND ISNULL(IMPOSTA,0) <> 0)' + @Cr +
					'														OR (LTRIM(RTRIM(ISNULL(CG33_CAUSALEIVA, CG33_CODICE))) IN(''91'',''92'') AND ISNULL(IMPOSTA,0) <> 0 AND ISNULL(CG0T_INDAUTOFATTURA,0) = 1)' + @Cr +
 					'													  THEN 6' + @Cr + --N6 - inversione contabile
 					'													  ELSE CASE WHEN FLGIVANOESP = 1' + @Cr + -- regime del margine / IVA non esposta in fattura
 					'																THEN CASE WHEN ISNULL(CG33_INDTIPOREG,0) = 2 AND ISNULL(CG07_TABSTATIEST.CG07_INDTIPOSTATO,-1) <> -1' + @Cr + -- esportazioni
					'																		  THEN 3' + @Cr + --N3 - non imponibili
					'																		  ELSE 5' + @Cr + --N5 - regime del margine / IVA non esposta in fattura
					'																		  END' + @Cr +
					'																ELSE CASE CG28_TIPOLOGIA' + @Cr +
 					'																		  WHEN 2 THEN CASE WHEN ISNULL(CG33_INDTIPOREG,0) = 2 AND ISNULL(CG07_TABSTATIEST.CG07_INDTIPOSTATO,-1) = 0 AND ISNULL(SERVIZI,0) <> 0' + @Cr + -- esportazioni extra UE
					'																						   THEN 2' + @Cr + --N2 - non soggette (Fuori campo IVA)
					'																						   ELSE 3' + @Cr + --N3 - non imponibili
					'																						   END' + @Cr +
 					'																		  WHEN 3 THEN 4' + @Cr + --N4 - esenti
 					'																		  WHEN 4 THEN 1' + @Cr + --N1 - escluse (Escluso)
 					'																		  WHEN 5 THEN 2' + @Cr + --N2 - non soggette (Fuori campo IVA)
					'																		  ELSE 0' + @Cr +
					'																		  END' + @Cr +
					'															    END' + @Cr +
 					'													  END' + @Cr +
 					'										    END' + @Cr +
					'								  ELSE 0' + @Cr +
					'								  END' + @Cr +
					'						END' + @Cr +
					'			  END AS INDNATURA,' + @Cr +
					'		 ISNULL(CG43_PERCDETR,0) AS CG43_PERCDETR,' + @Cr +
					'		 CG43_FLGDEDUCIBILE,' + @Cr +
					'		 CG28_FLGSOSPIMP,' + @Cr +
					'		 CASE WHEN LTRIM(RTRIM(ISNULL(CG33_CAUSALEIVA, CG33_CODICE))) IN(''93'',''94'')' + @Cr +
					'			  THEN CASE WHEN CG28_TIPOLOGIA = 1 THEN 2 ELSE 0 END' + @Cr +
					'			  ELSE CASE CG28_FLGSOSPIMP' + @Cr +
					'						WHEN 0 THEN 0' + @Cr +
					'						WHEN 1 THEN 1' + @Cr +
					'						WHEN 2 THEN 1' + @Cr +
					'						WHEN 3 THEN 2' + @Cr +
					'						ELSE 0' + @Cr +
					'				   END' + @Cr +
					'			  END INDIVASOSP,' + @Cr +
					'		 CG43_NUMRIGAIVA,' + @Cr +
					'		 FLGIVANOESP,' + @Cr +
					'		 CG41_ANAGRAPPFISC_CG16,' + @Cr +
					'		 CG41_ANAGSTABORG_CG16' + @Cr +
					' FROM (' + @Cr +
					'		 SELECT CG41_DITTA_CG18,' + @Cr +
					'				CG41_TIPOCF_CG44,' + @Cr +
					'				CG41_CLIFOR_CG44,' + @Cr +
					'				CG41_NUMREG, CG41_DATADOC, CG41_DATAREG,' + @Cr +
					'				CASE WHEN ISNULL(CG33_INDTIPOREG,0) = 2' + @Cr +
					'					 THEN CASE WHEN 0 = ' + cast(@IndNumDocDTE as nvarchar(2)) + @Cr +
					'							   THEN CASE WHEN ISNULL((SELECT TOP 1 CHARINDEX(''<<SEZIONALE>>'', CG7N_CODIFICA)' + @Cr +
					'													  FROM CG7N_PERSNUMDOC WITH(NOLOCK)' + @Cr +
					'													  WHERE CG7N_DITTA_CG18 = CG41_DITTA_CG18' + @Cr +
					'														AND CG7N_ANNO <= YEAR(CG41_DATAREG)' + @Cr +
					'													  ORDER BY CG7N_ANNO DESC),0) > 0' + @Cr +
					'										 THEN LTRIM(RTRIM(ISNULL(CG41_NUMDOCORIG,'''')))' + @Cr +
					'										 ELSE LTRIM(RTRIM(ISNULL(CG41_NUMDOCORIG,''''))) + ''/'' + LTRIM(RTRIM(ISNULL(CG41_SEZIONALE,'''')))' + @Cr +
					'										 END' + @Cr +
					'							   ELSE ISNULL(CAST(CG41_NUMDOC AS NVARCHAR(7)),'''') + CASE WHEN CG41_FLGDOCBIS = 1 THEN ''B'' ELSE '''' END + ''/'' + LTRIM(RTRIM(ISNULL(CG41_SEZIONALE,'''')))' + @Cr +
					'							   END' + @Cr +
					'					 ELSE CASE WHEN 0 = ' + cast(@IndNumDocDTR as nvarchar(2)) + @Cr +
					'							   THEN LTRIM(RTRIM(ISNULL(CG41_NUMDOCORIG,'''')))' + @Cr +
					'							   ELSE ISNULL(CAST(CG41_NUMDOC AS NVARCHAR(7)),'''') + CASE WHEN CG41_FLGDOCBIS = 1 THEN ''B'' ELSE '''' END + ''/'' + LTRIM(RTRIM(ISNULL(CG41_SEZIONALE,'''')))' + @Cr + 
					'							   END' + @Cr +
					'					 END AS NUMDOC,' + @Cr +
					'			    CG41_ANAGBLACKLIST_CG16,' + @Cr +
					'			    CG33_INDTIPOREG, CG33_CAUSALEIVA, CG33_CODICE,' + @Cr +
					'		 CASE WHEN (CG43_MOVIVA.CG43_INDTIPO IN(30, 31, 32, 33, 34, 60, 61, 62, 63, 64, 65, 66)' + @Cr +
					' 			  		OR CG28_TABCODIVA.CG28_INDTIPOPART = 1' + @Cr +
					' 			  		OR ISNULL(CG43_MOVIVA.CG43_INDNATURA,0) = 5' + @Cr +
					'				   )' + @Cr +
					'			  THEN 1' + @Cr +
					'			  ELSE 0' + @Cr +
					'			  END AS FLGIVANOESP,' + @Cr
	set @StrSql3 = @N + 
					'		 ISNULL((SELECT TOP 1 CG43_MOVIVA.CG43_CAUSALEIVA' + @Cr +
					'				 FROM (SELECT CASE WHEN CG43_MOVIVA.CG43_CAUSALEIVA IN (1, 4, 5, 10, 29) THEN 1 ELSE 0 END AS CG43_CAUSALEIVA,' + @Cr +
					'							  SUM(ISNULL(CG43_MOVIVA.CG43_IMPONIBILE,0)) AS CG43_IMPONIBILE' + @Cr +
					'					   FROM CG43_MOVIVA WITH(NOLOCK)' + @Cr +
					'					   WHERE CG43_MOVIVA.CG43_DITTA_CG18 = CG41_DITTA_CG18' + @Cr +
					'						 AND CG43_MOVIVA.CG43_NUMREG_CG41 = CG41_NUMREG' + @Cr +
					'						 /*AND CG43_MOVIVA.CG43_INDTIPO = 12*/' + @Cr +
					'					   GROUP BY (CASE WHEN CG43_MOVIVA.CG43_CAUSALEIVA IN (1, 4, 5, 10, 29) THEN 1 ELSE 0 END)' + @Cr +
					'					  ) AS CG43_MOVIVA' + @Cr +
					'				 ORDER BY CG43_MOVIVA.CG43_IMPONIBILE DESC, CG43_MOVIVA.CG43_CAUSALEIVA' + @Cr +
					'			   ),0) AS SERVIZI,' + @Cr +
					'		 CASE WHEN (LTRIM(RTRIM(ISNULL(CG33_CAUSALEIVA, CG33_CODICE))) IN (''7'',''9'',''35'',''42'',''52'',''92'',''94'',''97'') AND ISNULL(CG41_IMPTOTALE,0) >= 0) OR (LTRIM(RTRIM(ISNULL(CG33_CAUSALEIVA, CG33_CODICE))) IN (''5'',''37'',''39'',''63'',''81'',''285'') AND ISNULL(CG41_IMPTOTALE,0) < 0) THEN 1 ELSE CASE WHEN (LTRIM(RTRIM(ISNULL(CG33_CAUSALEIVA, CG33_CODICE))) IN (''5'',''37'',''39'',''63'',''81'',''285'') AND ISNULL(CG41_IMPTOTALE,0) >= 0) OR (LTRIM(RTRIM(ISNULL(CG33_CAUSALEIVA, CG33_CODICE))) IN (''7'',''9'',''35'',''42'',''52'',''92'',''94'',''97'') AND ISNULL(CG41_IMPTOTALE,0) < 0) THEN 2 ELSE 0 END END AS NOTAVAR,' + @Cr +
					'        CASE WHEN (LTRIM(RTRIM(ISNULL(CG33_CAUSALEIVA, CG33_CODICE))) IN (''7'',''9'') AND ISNULL(CG41_IMPTOTALE,0) >= 0) OR (LTRIM(RTRIM(ISNULL(CG33_CAUSALEIVA, CG33_CODICE))) IN (''37'',''39'') AND ISNULL(CG41_IMPTOTALE,0) < 0) THEN 1 ELSE CASE WHEN (LTRIM(RTRIM(ISNULL(CG33_CAUSALEIVA, CG33_CODICE))) IN (''37'',''39'') AND ISNULL(CG41_IMPTOTALE,0) >= 0) OR (LTRIM(RTRIM(ISNULL(CG33_CAUSALEIVA, CG33_CODICE))) IN (''7'',''9'') AND ISNULL(CG41_IMPTOTALE,0) < 0) THEN 2 ELSE 0 END END AS NOTADEB,' + @Cr +
					'	     ISNULL(CASE WHEN CG33_INDTIPOREG = 3' + @Cr +
					'		  			 THEN 0' + @Cr +
					'		  			 ELSE CASE WHEN NOT (CG43_MOVIVA.CG43_INDTIPO IN(30, 31, 32, 33, 34, 60, 61, 62, 63, 64, 65, 66)' + @Cr +
					' 			  							 OR CG28_TABCODIVA.CG28_INDTIPOPART = 1' + @Cr +
					' 			  							 OR ISNULL(CG43_MOVIVA.CG43_INDNATURA,0) = 5' + @Cr +
					'										)' + @Cr +
					'		  					   THEN ISNULL(CG43_IMPONIBILE,0)' + @Cr +
					'		  					   ELSE ISNULL(CG43_IMPONIBILE, 0) +' + @Cr +
					'		  							ISNULL(CG43_IMPOSTA, 0) +' + @Cr +
					'		  							ISNULL(CG43_IMPOSTAND, 0) END END, 0) AS IMPONIBILE,' + @Cr +
					'		  ISNULL(CASE WHEN CG33_INDTIPOREG = 3' + @Cr +
					'		  			  THEN 0' + @Cr +
					'			  		  ELSE CASE WHEN (CG43_MOVIVA.CG43_INDTIPO IN(30, 31, 32, 33, 34, 60, 61, 62, 63, 64, 65, 66)' + @Cr +
					' 			  						  OR CG28_TABCODIVA.CG28_INDTIPOPART = 1' + @Cr +
					' 			  						  OR ISNULL(CG43_MOVIVA.CG43_INDNATURA,0) = 5' + @Cr +
					'									 )' + @Cr +
					'			  					THEN 0' + @Cr +
					'			  					ELSE ISNULL(CG43_IMPOSTA,0) +' + @Cr +
					'			  						 ISNULL(CG43_IMPOSTAND,0) END END, 0) AS IMPOSTA,' + @Cr +
					'		  CG41_RIFPADRE,' + @Cr +
					'		  CG41_FLGDOCRIEP,' + @Cr +
 					'		  CG41_FLGDOCSEMPLIF,' + @Cr +
 					'		  CG43_NUMRIGAIVA,' + @Cr +
 					'		  CG43_INDTIPO,' + @Cr +
					'		  CG43_PERCDETR,' + @Cr +
					'		  CG43_FLGDEDUCIBILE,' + @Cr +
 					'		  CG28_PERCIVA,' + @Cr +
					'		  CG28_TIPOLOGIA,' + @Cr +
					'		  CG28_FLGSOSPIMP,' + @Cr +
					'		  CG28_INDNATURA,' + @Cr +
					'		  CG28_FLGMOSSGEST,' + @Cr +
					'		  CG41_INDTIPODOC,' + @Cr +
					'		  CG43_INDNATURA,' + @Cr +
					'		  CASE WHEN 1 < (SELECT COUNT(1)' + @Cr +
					'						 FROM (SELECT CG0T.CG0T_INDAUTOFATTURA' + @Cr +
					'							   FROM CG43_MOVIVA AS CG43 WITH(NOLOCK)' + @Cr +
					'		  					   LEFT OUTER JOIN CG0T_TIPOIVA AS CG0T WITH(NOLOCK)' + @Cr +
					'		  						 ON CG0T.CG0T_CODICE = CG43.CG43_CAUSALEIVA' + @Cr +
					'		  					   WHERE CG43.CG43_DITTA_CG18 = CG41_DITTA_CG18' + @Cr +
					'		  						 AND CG43.CG43_NUMREG_CG41 = CG41_NUMREG' + @Cr +
					'		  					   GROUP BY CG0T.CG0T_INDAUTOFATTURA' + @Cr +
					'							  ) AS CG43_MOVIVA' + @Cr +
					'						)' + @Cr +
					'			   THEN CG0T_INDAUTOFATTURA' + @Cr +
					'			   ELSE 1' + @Cr +
					'			   END AS CG0T_INDAUTOFATTURA,' + @Cr +
					'		 CG41_ANAGRAPPFISC_CG16,' + @Cr +
					'		 CG41_ANAGSTABORG_CG16' + @Cr +
					'		FROM CG41_PRIMANOTA WITH(NOLOCK)' + @Cr +
					'		INNER JOIN CG42_MOVCONT WITH(NOLOCK)' + @Cr +
					'		   ON CG42_MOVCONT.CG42_DITTA_CG18 = CG41_PRIMANOTA.CG41_DITTA_CG18' + @Cr +
					'		  AND CG42_MOVCONT.CG42_NUMREG_CG41 = CG41_PRIMANOTA.CG41_NUMREG' + @Cr +
					'		INNER JOIN CG43_MOVIVA WITH(NOLOCK)' + @Cr +
					'		   ON CG43_MOVIVA.CG43_DITTA_CG18 = CG42_MOVCONT.CG42_DITTA_CG18' + @Cr +
					'		  AND CG43_MOVIVA.CG43_NUMREG_CG41 = CG42_MOVCONT.CG42_NUMREG_CG41' + @Cr +
					'		  AND CG43_MOVIVA.CG43_NUMRIGAIVA = CG42_MOVCONT.CG42_PROGIVA_CG43' + @Cr +
 					'		LEFT OUTER JOIN CG28_TABCODIVA WITH(NOLOCK)' + @Cr +
 					'		  ON CG28_TABCODIVA.CG28_CODICE = CG43_MOVIVA.CG43_ALIQIVA1_CG28' + @Cr +
					'       LEFT OUTER JOIN CG68_NUMERDESC WITH(NOLOCK)' + @Cr +
					'         ON CG68_DITTA_CG18 = CG41_DITTA_CG18' + @Cr +
					'        AND CG68_SEZIONALE = CG41_SEZIONALE' + @Cr +
					' 		LEFT OUTER JOIN CG33_TABCAU WITH(NOLOCK)' + @Cr +
					' 		  ON CG33_TABCAU.CG33_CODICE = CG41_CODICE_CG33' + @Cr +
					' 		LEFT OUTER JOIN VCG16_ANAGRALLADATA' + @Cr +
					' 		  ON VCG16_ANAGRALLADATA.CG44_DITTA_CG18 = CG41_DITTA_CG18' + @Cr +
					' 		 AND VCG16_ANAGRALLADATA.CG44_TIPOCF = CG41_TIPOCF_CG44' + @Cr +
					' 		 AND VCG16_ANAGRALLADATA.CG44_CLIFOR = CG41_CLIFOR_CG44' + @Cr +
					' 		 AND ISNULL(CG41_DATADOC,CG41_DATAREG) >= ISNULL(VCG16_ANAGRALLADATA.DATAINIZIOVALIDITA, ''17530101'')' + @Cr +
					' 		 AND ISNULL(CG41_DATADOC,CG41_DATAREG) <= ISNULL(VCG16_ANAGRALLADATA.DATAFINEVALIDITA, ''99991231'')' + @Cr +
                    '        LEFT OUTER JOIN CG25_ANADITTAGEST WITH(NOLOCK)' + @Cr +
                    '          ON CG25_ANADITTAGEST.CG25_DITTA_CG18 = CG41_PRIMANOTA.CG41_DITTA_CG18' + @Cr +
                    '        LEFT OUTER JOIN CG32_ANADITTAPSEZ WITH(NOLOCK)' + @Cr +
                    '          ON CG32_ANADITTAPSEZ.CG32_DITTA_CG18 = CG41_PRIMANOTA.CG41_DITTA_CG18 ' + @Cr +
                    '         AND CG32_ANADITTAPSEZ.CG32_ANNO = YEAR(ISNULL(ISNULL(CG41_PRIMANOTA.CG41_DATADOC, CG41_PRIMANOTA.CG41_DATAREGIVA), CG41_PRIMANOTA.CG41_DATAREG))' + @Cr +
                    '         AND CG32_ANADITTAPSEZ.CG32_SEZIONALE = CG41_PRIMANOTA.CG41_SEZIONALE' + @Cr +
                    '        LEFT OUTER JOIN CG86_AZIENDECOLL WITH(NOLOCK)' + @Cr +
                    '          ON CG86_AZIENDECOLL.CG86_IDATTIVITA = CASE WHEN ISNULL(CG32_ANADITTAPSEZ.CG32_IDATTIVITA_CG86, 0) <> 0' + @Cr +
                    '                                                     THEN CG32_ANADITTAPSEZ.CG32_IDATTIVITA_CG86' + @Cr +
                    '                                                     ELSE (SELECT TOP 1 CG86.CG86_IDATTIVITA' + @Cr +
                    '                                                           FROM CG86_AZIENDECOLL AS CG86 WITH(NOLOCK)' + @Cr +
                    '                                                           LEFT OUTER JOIN CG25_ANADITTAGEST AS CG25 WITH(NOLOCK)' + @Cr +
                    '                                                             ON CG25.CG25_DITTA_CG18 = CG86.CG86_DITTACOLL_CG18' + @Cr +
                    '                                                           WHERE CG86.CG86_DITTACOLL_CG18 = CG32_ANADITTAPSEZ.CG32_DITTA_CG18' + @Cr +
                    '                                                             AND CG86.CG86_ANNOIVA = CG32_ANADITTAPSEZ.CG32_ANNO' + @Cr +
                    '                                                             AND CG25.CG25_FLGIVAQUATER IN(0, 1)' + @Cr +
                    '                                                             AND CG86.CG86_INDTIPO = 0) END' + @Cr +
                    '        LEFT OUTER JOIN CG96_ANAGATTIVITA WITH(NOLOCK)' + @Cr +
                    '          ON CG96_ANAGATTIVITA.CG96_DITTA_CG18 = CG41_PRIMANOTA.CG41_DITTA_CG18' + @Cr +
                    '         AND CG96_ANAGATTIVITA.CG96_CODATTIVITA = CG86_AZIENDECOLL.CG86_CODATTIVITA' + @Cr +
					'		 LEFT OUTER JOIN CG0T_TIPOIVA WITH(NOLOCK)' + @Cr +
					'		   ON CG0T_TIPOIVA.CG0T_CODICE = CG43_MOVIVA.CG43_CAUSALEIVA' + @Cr +
					'		WHERE CG41_DITTA_CG18 IN( ' + @DitteColl + ')' + @Cr +
                    '         AND (   (CG33_INDTIPOREG = 1' + @Cr +
                    '                  AND CG41_PRIMANOTA.CG41_DATAREG BETWEEN ''' + @DataInizioElaborazione + ''' AND ''' + @DataFineElaborazione + '''' + @Cr +
                    '                 )' + @Cr +
                    '              OR (CG33_INDTIPOREG = 2' + @Cr +
					'				   AND NOT(CG86_AZIENDECOLL.CG86_INDTIPODEN=1 AND CG25_ANADITTAGEST.CG25_FLGPOSTICIP = 0 AND CG86_AZIENDECOLL.CG86_FLGGESBENZ = 1 AND CG96_ANAGATTIVITA.CG96_INDCATPART = 1)' + @Cr +
                    '                  AND ISNULL(CG41_PRIMANOTA.CG41_DATADOC,CG41_PRIMANOTA.CG41_DATAREG) BETWEEN ''' + @DataInizioElaborazione + ''' AND ''' + @DataFineElaborazione + '''' + @Cr +
                    '                 )' + @Cr +
                    '              OR (CG33_INDTIPOREG = 2' + @Cr +
					'				   AND    (CG86_AZIENDECOLL.CG86_INDTIPODEN=1 AND CG25_ANADITTAGEST.CG25_FLGPOSTICIP = 0 AND CG86_AZIENDECOLL.CG86_FLGGESBENZ = 1 AND CG96_ANAGATTIVITA.CG96_INDCATPART = 1)' + @Cr +
                    '				   AND CG41_PRIMANOTA.CG41_DATAREGIVA BETWEEN ''' + @DataInizioElaborazione + ''' AND ''' + @DataFineElaborazione + '''' + @Cr +
                    '                 )' + @Cr +
                    '             )' + @Cr +
					'		  AND CG41_INDTIPOMOV = 0' + @Cr +
					' 		  AND CG41_INDPROVREG = 0' + @Cr +
					'		  AND CG41_INDELENCHIMOV3000 IN(1,2,3)' + @Cr +
					' 		  AND CG33_INDTIPOREG IN (1,2)' + @Cr +
					'		  AND CG68_FLGNOLIQIVA = 0' + @Cr
	set @StrSql4 = @N + 
					' 		  AND EXISTS (SELECT TOP 1 1' + @Cr +
					' 					  FROM CG43_MOVIVA AS CG43 WITH(NOLOCK)' + @Cr +
					' 			  		  WHERE CG43.CG43_DITTA_CG18 = CG41_PRIMANOTA.CG41_DITTA_CG18' + @Cr +                  
					' 			    		AND CG43.CG43_NUMREG_CG41 = CG41_PRIMANOTA.CG41_NUMREG' + @Cr +   
					' 			    		AND (CG43.CG43_INDTIPO IN(1, 2, 3, 4, 6, 7, 8, 12, 15, 16, 18, 19, 21, 30, 31, 32, 33, 34, 38, 40, 50, 51, 55, 56, 60, 61, 62, 63, 64, 65, 66, 85, 86, 88, 90, 91, 92, 96)' + @Cr +
					' 			    			 OR (CG43.CG43_INDTIPO IN(14, 39, 87)' + @Cr +
					'								 AND CG33_TABCAU.CG33_INDTIPOREG = 2' + @Cr +
					'								 AND (  (CG41_PRIMANOTA.CG41_RIFPADRE IS NULL' + @Cr +
					'										 AND LTRIM(RTRIM(ISNULL(CG33_TABCAU.CG33_CAUSALEIVA, CG33_TABCAU.CG33_CODICE))) = ''62''' + @Cr +
					'									    )' + @Cr +
					'									  OR (CG41_PRIMANOTA.CG41_RIFPADRE IS NOT NULL' + @Cr +
					'										  AND 0=1 /*EXISTS(SELECT TOP 1 1' + @Cr +
					'					   								 FROM CG41_PRIMANOTA AS CG41 WITH(NOLOCK)' + @Cr +
  					'									  				 LEFT OUTER JOIN CG33_TABCAU AS CG33 WITH(NOLOCK)' + @Cr +
  					'													   ON CG33.CG33_CODICE = CG41.CG41_CODICE_CG33' + @Cr +
					'									  				 WHERE CG41.CG41_DITTA_CG18 = CG41_PRIMANOTA.CG41_DITTA_CG18' + @Cr +
					'													   AND CG41.CG41_NUMREG = CG41_PRIMANOTA.CG41_RIFPADRE' + @Cr +
					'													   AND LTRIM(RTRIM(ISNULL(CG33.CG33_CAUSALEIVA, CG33.CG33_CODICE))) IN(''96'',''97'')' + @Cr +
					'													   AND CG41.CG41_INDELENCHIMOV3000 IN(1,2,3)' + @Cr +
					'												     )*/' + @Cr +
					'										)' + @Cr +
					'									)' + @Cr +
					'								)' + @Cr +
					'							)' + @Cr +
					'					)' + @Cr +
					'		  AND NOT EXISTS (SELECT TOP 1 1' + @Cr +
					'						  FROM CG3R_DATIFATTURE AS CG3R WITH(NOLOCK)' + @Cr +
					'						  WHERE CG3R.CG3R_DITTACOLL_CG18 = CG41_DITTA_CG18' + @Cr +
					'						    AND CG3R.CG3R_NUMREG_CO99 = CG41_NUMREG' + @Cr +
					'						 )' + @Cr +
					' ) AS PRIMANOTA' + @Cr +
					' LEFT OUTER JOIN (SELECT CG4E.CG4E_DITTA_CG18, CG4E.CG4E_TIPOCF_CG44, CG4E.CG4E_CLIFOR_CG44,' + @Cr +
					'						  ISNULL((SELECT MAX(CG4E_CF.CG4E_CLIFORCO_CG44) AS CG4E_CLIFORCO_CG44' + @Cr +
					'								  FROM CG4E_CFCOINTESTATI AS CG4E_CF WITH(NOLOCK)' + @Cr +
					'								  WHERE CG4E_CF.CG4E_DITTA_CG18 = CG4E.CG4E_DITTA_CG18' + @Cr +
					'									AND CG4E_CF.CG4E_TIPOCF_CG44 = CG4E.CG4E_TIPOCF_CG44' + @Cr +
					'									AND CG4E_CF.CG4E_CLIFOR_CG44 = CG4E.CG4E_CLIFOR_CG44' + @Cr +
					'									AND CG4E_CF.CG4E_PERCENTUALE = (SELECT MAX(CG4E_PERC.CG4E_PERCENTUALE) AS CG4E_PERCENTUALE' + @Cr +
				 	'																    FROM CG4E_CFCOINTESTATI AS CG4E_PERC WITH(NOLOCK)' + @Cr +
					'																	WHERE CG4E_PERC.CG4E_DITTA_CG18 = CG4E_CF.CG4E_DITTA_CG18' + @Cr +
					'																	  AND CG4E_PERC.CG4E_TIPOCF_CG44 = CG4E_CF.CG4E_TIPOCF_CG44' + @Cr +
					'																	  AND CG4E_PERC.CG4E_CLIFOR_CG44 = CG4E_CF.CG4E_CLIFOR_CG44' + @Cr +
					'																	)' + @Cr +
					'								),0) AS CG4E_CLIFORCO_CG44,' + @Cr +
					'						  100 AS CG4E_PERCENTUALE' + @Cr +
					'				   FROM CG4E_CFCOINTESTATI AS CG4E WITH(NOLOCK)' + @Cr +
					'				   GROUP BY CG4E.CG4E_DITTA_CG18, CG4E.CG4E_TIPOCF_CG44, CG4E.CG4E_CLIFOR_CG44' + @Cr +
					'				   ) AS CG4E' + @Cr +
					'   ON CG4E.CG4E_DITTA_CG18 = CG41_DITTA_CG18' + @Cr +
					'  AND CG4E.CG4E_TIPOCF_CG44 = CG41_TIPOCF_CG44' + @Cr +
					'  AND CG4E.CG4E_CLIFOR_CG44 = CG41_CLIFOR_CG44' + @Cr +
					' LEFT OUTER JOIN VCG16_ANAGRALLADATA' + @Cr +
					'   ON VCG16_ANAGRALLADATA.CG44_DITTA_CG18 = CG41_DITTA_CG18' + @Cr +
					'  AND VCG16_ANAGRALLADATA.CG44_TIPOCF = CG41_TIPOCF_CG44' + @Cr +
					'  AND VCG16_ANAGRALLADATA.CG44_CLIFOR = ISNULL(CG4E.CG4E_CLIFORCO_CG44, CG41_CLIFOR_CG44)' + @Cr +
					'  AND ISNULL(CG41_DATADOC,CG41_DATAREG) >= ISNULL(VCG16_ANAGRALLADATA.DATAINIZIOVALIDITA, ''17530101'')' + @Cr +
					'  AND ISNULL(CG41_DATADOC,CG41_DATAREG) <= ISNULL(VCG16_ANAGRALLADATA.DATAFINEVALIDITA, ''99991231'')' + @Cr +
					'  AND EXISTS(SELECT TOP 1 1 FROM CG33_TABCAU AS CG33 WITH(NOLOCK) WHERE CG33.CG33_CODICE = PRIMANOTA.CG33_CODICE AND CG33.CG33_INDTIPOREG <> 3)' + @Cr +
					' LEFT OUTER JOIN VCG16_ANAGGENVALIDA AS VCG16_ANAGGEN' + @Cr +
  					'   ON VCG16_ANAGGEN.CG16_CODICE = VCG16_ANAGRALLADATA.CG16_CODICE' + @Cr +
					'  AND ISNULL(CG41_DATADOC,CG41_DATAREG) >= ISNULL(VCG16_ANAGGEN.DATAINIZIOVALIDITA, ''17530101'')' + @Cr +
					'  AND ISNULL(CG41_DATADOC,CG41_DATAREG) <= ISNULL(VCG16_ANAGGEN.DATAFINEVALIDITA, ''99991231'')' + @Cr +
					' OUTER APPLY dbo.FNCG07_TABSTATIEST(VCG16_ANAGGEN.CG16_CODICE_CG07, CG41_DITTA_CG18) AS CG07_TABSTATIEST' + @Cr

	if @IndTransfrontalieri = 1
		set @StrSql4 = @StrSql4 + 
					' WHERE (ISNULL(CG07_TABSTATIEST.CG07_INDTIPOSTATO,-1) <> -1' + @Cr +
					'        OR ISNULL(CG07_TABSTATIEST.CG07_CODICE,-1) = ' + cast(@StatoCampioneItalia as nvarchar(4)) + @Cr +
					'        OR ISNULL(VCG16_ANAGGEN.CG16_COMANA_CG01,'''') = ''' + @ComuneLivigno + '''' + @Cr +
					'		)' + @Cr +
					'   AND LTRIM(RTRIM(ISNULL(CG33_CAUSALEIVA, CG33_CODICE))) NOT IN(''71'')' + @Cr

	set @StrSql4 = @StrSql4 + 
					' ) AS PRIMANOTA' + @Cr +
					' ) AS PRIMANOTA' + @Cr +
					' GROUP BY INDTIPOREC, CG41_DITTA_CG18, CG41_TIPOCF_CG44, CG41_CLIFOR_CG44, CODANAG, PARTITAIVA, CODFISCALE, CG41_NUMREG, INDTIPODOC, CG41_DATADOC, NUMDOC, CG41_DATAREG, FLGIVANOESP,' + @Cr +
 					'		   CG28_PERCIVA, INDNATURA, CG43_PERCDETR, CG43_FLGDEDUCIBILE, INDIVASOSP, INDRAGGR, CG41_ANAGRAPPFISC_CG16, CG41_ANAGSTABORG_CG16' + @Cr
	set @StrSql5 = @N + 
					' UNION ALL' + @Cr +
					' SELECT ' + cast(@CodDittaPrincipale as nvarchar(5)) + ' AS CG3R_DITTA_CG18, ' + @Cr +
					'		 ' + cast(@Anno as nvarchar(4)) + ' AS CG3R_ANNO, ' + @Cr +
					'		 ' + cast(@Mese as nvarchar(2)) + ' AS CG3R_MESE, ' + @Cr +
					'		 ' + cast(@IndPeriodo as nvarchar(2)) + ' AS CG3R_INDPERIODO, ' + @Cr +
					'        ' + cast(@IndProv as nvarchar(2)) + ' AS CG3R_INDPROV,' + @Cr +
					'        0 AS CG3R_INDTIPOINVIO,' + @Cr +
					'		 CG3R_INDTIPOREC,' + @Cr +
					'		 CG3R_DITTACOLL_CG18,' + @Cr +
					'		 CG3R_TIPOCF_CG44,' + @Cr +
					'		 CG3R_CLIFOR_CG44,' + @Cr + 
					'		 CASE WHEN (PARTITAIVA IS NULL OR (PARTITAIVA IN (''' + @PartitaIVANonRaggr + ''') AND CG3R_INDTIPOREC = 2))  AND CODFISCALE IS NULL' + @Cr +
					'			  THEN CG3R_CODICE_CG16' + @Cr +
					'			  ELSE ISNULL((SELECT TOP 1 CG16_CODICE' + @Cr +
					'						   FROM ' + @NomeTabellaTmpCG16 + ' AS VCG16' + @Cr +
					'						   WHERE ISNULL(VCG16.PARTIVA,'''') = ISNULL(PARTITAIVA,'''')' + @Cr +
					'							 AND ISNULL(VCG16.CG16_CODFISCALE,'''') = ISNULL(CODFISCALE,'''')' + @Cr +
					'						   ORDER BY VCG16.CG16_FLGOMONIMO DESC, VCG16.CG16_CODICE DESC' + @Cr +
					'				   ),CG3R_CODICE_CG16)' + @Cr +
					'			  END AS CG3R_CODICE_CG16,' + @Cr +
					'		 PARTITAIVA,' + @Cr +
					'		 CODFISCALE,' + @Cr +
					'		 CG3R_NUMREG_CO99,' + @Cr +
					'		 CG3R_INDTIPODOC,' + @Cr +
					'		 ISNULL(CG3R_DATADOC,CG3R_DATAREG) AS CG3R_DATADOC,' + @Cr +
					'		 CG3R_NUMDOC,' + @Cr +
					'		 CG3R_DATAREG,' + @Cr +
					'		 SUM(ISNULL(CG3R_IMPORTO,0) + CASE WHEN CG3R_INDTIPODOC IN (7,8) THEN ISNULL(CG3R_IMPOSTA,0) ELSE 0 END) AS CG3R_IMPORTO,' + @Cr +
					'		 SUM(CASE WHEN CG3R_INDTIPODOC IN (7,8) THEN NULL ELSE ISNULL(CG3R_IMPOSTA,0) END) AS CG3R_IMPOSTA,' + @Cr +
					'		 CASE WHEN CG3R_INDNATURA = 5 THEN 0 ELSE ISNULL(CG3R_PERCIVA,0) END AS CG3R_PERCIVA,' + @Cr +
					'		 CG3R_INDNATURA,' + @Cr +
					'		 ISNULL(CG3R_PERCDETR,0) AS CG3R_PERCDETR,' + @Cr +
					'		 CG3R_INDDEDUC,' + @Cr +
					'		 CG3R_INDIVASOSP,' + @Cr +
					'		 CG3R_ID AS CG3R_ID_CG3R,' + @Cr +
					'		 CG3R_ANAGRAPPFISC_CG16,' + @Cr +
					'		 CG3R_ANAGSTABORG_CG16' + @Cr +
					' FROM (SELECT CG3R_DATIFATTURE.*,' + @Cr +
					'			   VCG16_ANAGGEN.PARTIVA AS PARTITAIVA,' + @Cr +
					'			   VCG16_ANAGGEN.CG16_CODFISCALE AS CODFISCALE' + @Cr +
					'		FROM CG3R_DATIFATTURE WITH(NOLOCK)' + @Cr +
					'		LEFT OUTER JOIN VCG16_ANAGGENVALIDA AS VCG16_ANAGGEN' + @Cr +
  					'		  ON VCG16_ANAGGEN.CG16_CODICE = CG3R_CODICE_CG16' + @Cr +
					'		 AND ISNULL(ISNULL(CG3R_DATADOC,CG3R_DATAREG),''' + @DataFineComunicazione + ''') >= ISNULL(VCG16_ANAGGEN.DATAINIZIOVALIDITA, ''17530101'')' + @Cr +
					'		 AND ISNULL(ISNULL(CG3R_DATADOC,CG3R_DATAREG),''' + @DataFineComunicazione + ''') <= ISNULL(VCG16_ANAGGEN.DATAFINEVALIDITA, ''99991231'')' + @Cr +
					'		WHERE CG3R_DITTA_CG18 = ' + cast(@CodDittaPrincipale as nvarchar(5)) + @Cr +
					'		  AND CG3R_ANNO = ' + cast(@Anno as nvarchar(4)) + @Cr +
					'		  AND CG3R_MESE = ' + cast(@Mese as nvarchar(2)) + @Cr +
					'		  AND CG3R_INDPERIODO = ' + cast(@IndPeriodo as nvarchar(2)) + @Cr +
					'		  AND CG3R_INDPROV IN(0,1)' + @Cr +
					'		  AND NOT EXISTS (SELECT TOP 1 1' + @Cr +
					'						  FROM CG3R_DATIFATTURE AS CG3R WITH(NOLOCK)' + @Cr +
					'						  WHERE CG3R.CG3R_ID_CG3R = CG3R_DATIFATTURE.CG3R_ID' + @Cr +
					'						 )' + @Cr +
					'		) AS MOVMANUALI' + @Cr +
					' GROUP BY CG3R_DITTA_CG18, CG3R_ANNO, CG3R_MESE, CG3R_INDPERIODO, CG3R_INDPROV, CG3R_INDTIPOINVIO, CG3R_INDTIPOREC,' + @Cr +
					'		   CG3R_DITTACOLL_CG18, CG3R_TIPOCF_CG44, CG3R_CLIFOR_CG44, CG3R_CODICE_CG16, PARTITAIVA, CODFISCALE, CG3R_NUMREG_CO99, CG3R_INDTIPODOC, CG3R_DATADOC, CG3R_NUMDOC, CG3R_DATAREG,' + @Cr +
					'		   CG3R_PERCIVA, CG3R_INDNATURA, CG3R_PERCDETR, CG3R_INDDEDUC, CG3R_INDIVASOSP, CG3R_ID, CG3R_ANAGRAPPFISC_CG16, CG3R_ANAGSTABORG_CG16' + @Cr +
					' ) AS DATIFATTURE' + @Cr +
					' LEFT OUTER JOIN VCG16_DATIFATTURE AS VCG16_ANAGGEN' + @Cr +
  					'   ON VCG16_ANAGGEN.CG16_CODICE = CG3R_CODICE_CG16' + @Cr +
					'  AND ''' + @DataFineComunicazione + ''' >= ISNULL(VCG16_ANAGGEN.DATAINIZIOVALIDITA, ''17530101'')' + @Cr +
					'  AND ''' + @DataFineComunicazione + ''' <= ISNULL(VCG16_ANAGGEN.DATAFINEVALIDITA, ''99991231'')' + @Cr +
					' OUTER APPLY dbo.FNCG07_TABSTATIEST(VCG16_ANAGGEN.CG16_CODICE_CG07, CG3R_DITTA_CG18) AS CG07_TABSTATIEST' + @Cr +
					' ) AS DATIFATTURE' + @Cr +
					' ORDER BY CG3R_DITTA_CG18, CG3R_ANNO, CG3R_MESE, CG3R_INDPERIODO, CG3R_INDPROV, CG3R_INDTIPOINVIO, CG3R_INDTIPOREC, PARTIVA, CG16_CODFISCALE, CG16_RAGSOANAG, CG3R_CODICE_CG16, CG3R_ANAGRAPPFISC_CG16, CG3R_ANAGSTABORG_CG16, CASE WHEN CG3R_INDTIPODOC = 12 THEN 1 ELSE 0 END, ISNULL(CG3R_DATADOC,CG3R_DATAREG), CG3R_NUMDOC, CG3R_DATAREG, CG3R_INDTIPODOC, CG3R_DITTACOLL_CG18, CG3R_NUMREG_CO99, CG3R_IMPORTO, CG3R_IMPOSTA, CG3R_PERCIVA, CG3R_INDNATURA, CG3R_PERCDETR, CG3R_INDDEDUC, CG3R_INDIVASOSP' + @Cr

	execute (@StrSql1 + @StrSql2 + @StrSql3 + @StrSql4 + @StrSql5)

	IF @@ROWCOUNT = 0
		RETURN

	/* Inserimento delle fatture nella tabella del vecchio spesometro per far scattare il controllo in fase di eliminazione da PN basato sulla CG3J_SPESOMETRO */
	INSERT INTO CG3J_SPESOMETRO (CG3J_DITTA_CG18, CG3J_ANNO, CG3J_MESE, CG3J_DITTACOLL_CG18, CG3J_NUMREG_CO99)
	SELECT CG3R_DITTA_CG18, 0, 0, CG3R_DITTACOLL_CG18, CG3R_NUMREG_CO99
	FROM CG3R_DATIFATTURE WITH(NOLOCK)
	WHERE CG3R_DITTA_CG18 = @CodDittaPrincipale
	  AND CG3R_ANNO = @Anno
	  AND CG3R_MESE = @Mese
	  AND CG3R_INDPERIODO = @IndPeriodo
	  AND CG3R_INDPROV = @IndProv
	  AND CG3R_NUMREG_CO99 IS NOT NULL
	  AND NOT EXISTS(SELECT TOP 1 1
					 FROM CG3J_SPESOMETRO WITH(NOLOCK)
					 WHERE CG3J_DITTACOLL_CG18 = CG3R_DITTACOLL_CG18
					   AND CG3J_NUMREG_CO99 = CG3R_NUMREG_CO99
					)
	GROUP BY CG3R_DITTA_CG18, CG3R_DITTACOLL_CG18, CG3R_NUMREG_CO99



	/**************************
	*  AGGIORNAMENTO NUM DOC  *
	***************************/

	DECLARE @TabAlphabet TABLE (ID INT IDENTITY,
								LETTERA NVARCHAR(2) COLLATE DATABASE_DEFAULT)

	INSERT INTO @TabAlphabet(LETTERA)
		VALUES(''),('A'),('B'),('C'),('D'),('E'),('F'),('G'),('H'),('I'),('J'),('K'),('L'),('M'),('N'),('O'),('P'),('Q'),('R'),('S'),('T'),('U'),('V'),('W'),('X'),('Y'),('Z')

	INSERT INTO @TabAlphabet(LETTERA)
		SELECT B.LETTERA + A.LETTERA AS LETTERA
		FROM @TabAlphabet AS A
		CROSS JOIN @TabAlphabet AS B
		WHERE A.LETTERA <> ''
			AND B.LETTERA <> ''

	/* Aggiornamento numero documento uguali */
	if isnull(@InserisciLetteraNumDoc,0) = 1
	begin
		
		set @IndTipoRec = 1

		DECLARE @TabCG3RNumDoc TABLE (ID			BIGINT,
									  DITTA			DECIMAL(5),
									  ANNO			SMALLINT,
									  MESE			TINYINT,
									  INDPERIODO	TINYINT,
									  INDPROV		TINYINT,
									  INDTIPOINVIO	TINYINT,
									  INDTIPOREC	TINYINT,
									  DITTACOLL		DECIMAL(5),
									  TIPOCF		DECIMAL(1, 0),
									  CLIFOR		DECIMAL(8, 0),
									  CODICE_CG16		INT,
									  ANAGRAPPFISC_CG16	INT,
									  ANAGSTABORG_CG16	INT,
									  NUMREG		CHAR(12) COLLATE DATABASE_DEFAULT,
									  INDTIPODOC	TINYINT,
									  DATADOC		DATETIME,
									  NUMDOC		NVARCHAR(20) COLLATE DATABASE_DEFAULT,
									  DATAREG		DATETIME,
									  NUMDOCAGG		NVARCHAR(20) COLLATE DATABASE_DEFAULT,
									  ID_CG3T		BIGINT)

		INSERT INTO @TabCG3RNumDoc (ID, DITTA, ANNO, MESE, INDPERIODO, INDPROV, INDTIPOINVIO, INDTIPOREC, DITTACOLL, TIPOCF, CLIFOR, CODICE_CG16, ANAGRAPPFISC_CG16, ANAGSTABORG_CG16, NUMREG, INDTIPODOC, DATADOC, NUMDOC, DATAREG, NUMDOCAGG, ID_CG3T)
			SELECT CG3R.CG3R_ID, CG3R.CG3R_DITTA_CG18, CG3R.CG3R_ANNO, CG3R.CG3R_MESE, CG3R.CG3R_INDPERIODO, CG3R.CG3R_INDPROV, CG3R.CG3R_INDTIPOINVIO, CG3R.CG3R_INDTIPOREC, CG3R.CG3R_DITTACOLL_CG18, CG3R.CG3R_TIPOCF_CG44, CG3R.CG3R_CLIFOR_CG44, CG3R.CG3R_CODICE_CG16, CG3R.CG3R_ANAGRAPPFISC_CG16, CG3R.CG3R_ANAGSTABORG_CG16, CG3R.CG3R_NUMREG_CO99, CG3R.CG3R_INDTIPODOC, CG3R.CG3R_DATADOC, CG3R.CG3R_NUMDOC, CG3R.CG3R_DATAREG, CG3R.CG3R_NUMDOCAGG, CG3R.CG3R_ID_CG3T
			FROM CG3R_DATIFATTURE AS CG3R WITH(NOLOCK)
			WHERE CG3R.CG3R_DITTA_CG18 = @CodDittaPrincipale
			  AND CG3R.CG3R_ANNO = @Anno
			  AND CG3R.CG3R_INDPROV = @IndProv
			  AND CG3R.CG3R_INDTIPOINVIO IN (0,1,2) --Elaborato, Generato, Inviato
			  AND CG3R.CG3R_INDTIPOREC = @IndTipoRec
			  AND 1 < (SELECT COUNT(1)
					   FROM (SELECT CG3R_3.CG3R_DITTA_CG18, CG3R_3.CG3R_ANNO, CG3R_3.CG3R_MESE, CG3R_3.CG3R_INDPERIODO, CG3R_3.CG3R_INDPROV, CG3R_3.CG3R_INDTIPOINVIO, CG3R_3.CG3R_INDTIPOREC, CG3R_3.CG3R_DITTACOLL_CG18,
									CG3R_3.CG3R_TIPOCF_CG44, CG3R_3.CG3R_CLIFOR_CG44, CG3R_3.CG3R_CODICE_CG16, CG3R_3.CG3R_ANAGRAPPFISC_CG16, CG3R_3.CG3R_ANAGSTABORG_CG16, CG3R_3.CG3R_NUMREG_CO99, CG3R_3.CG3R_INDTIPODOC, CG3R_3.CG3R_DATADOC, CG3R_3.CG3R_NUMDOC, CG3R_3.CG3R_DATAREG
							 FROM CG3R_DATIFATTURE AS CG3R_3 WITH(NOLOCK)
							 WHERE CG3R_3.CG3R_DITTA_CG18 = CG3R.CG3R_DITTA_CG18
							   AND CG3R_3.CG3R_ANNO = CG3R.CG3R_ANNO
							   AND CG3R_3.CG3R_INDPROV = CG3R.CG3R_INDPROV
							   AND CG3R_3.CG3R_INDTIPOINVIO IN (0,1,2)
							   AND CG3R_3.CG3R_INDTIPOREC = CG3R.CG3R_INDTIPOREC
							 GROUP BY CG3R_3.CG3R_DITTA_CG18, CG3R_3.CG3R_ANNO, CG3R_3.CG3R_MESE, CG3R_3.CG3R_INDPERIODO, CG3R_3.CG3R_INDPROV, CG3R_3.CG3R_INDTIPOINVIO, CG3R_3.CG3R_INDTIPOREC, CG3R_3.CG3R_DITTACOLL_CG18,
									  CG3R_3.CG3R_TIPOCF_CG44, CG3R_3.CG3R_CLIFOR_CG44, CG3R_3.CG3R_CODICE_CG16, CG3R_3.CG3R_ANAGRAPPFISC_CG16, CG3R_3.CG3R_ANAGSTABORG_CG16, CG3R_3.CG3R_NUMREG_CO99, CG3R_3.CG3R_INDTIPODOC, CG3R_3.CG3R_DATADOC, CG3R_3.CG3R_NUMDOC, CG3R_3.CG3R_DATAREG
							) AS CG3R_2
					   WHERE CG3R_2.CG3R_DITTA_CG18 = CG3R.CG3R_DITTA_CG18
						 AND CG3R_2.CG3R_ANNO = CG3R.CG3R_ANNO
						 AND CG3R_2.CG3R_INDPROV = CG3R.CG3R_INDPROV
						 AND CG3R_2.CG3R_INDTIPOINVIO IN (0,1,2) --Elaborato, Generato, Inviato
						 AND CG3R_2.CG3R_INDTIPOREC = CG3R.CG3R_INDTIPOREC
						 AND CG3R_2.CG3R_DITTACOLL_CG18 = CG3R.CG3R_DITTACOLL_CG18
						 AND CG3R_2.CG3R_NUMDOC = CG3R.CG3R_NUMDOC
					   )

		/* Determina se esistono record del telematico da aggiornare con il numero documento aggiuntivo */
		set @IsAggiornaRec = (SELECT TOP 1 1
							  FROM @TabCG3RNumDoc AS CG3R
							  WHERE CG3R.MESE = @Mese
								AND CG3R.INDPERIODO = @IndPeriodo
								AND CG3R.NUMDOCAGG IS NULL
								AND CG3R.ID_CG3T IS NULL
							  )

		if isnull(@IsAggiornaRec,0) = 1
		begin

			/* Ciclo fino a quando non ho aggiornato tutti i record del telematico con il numero documento aggiuntivo */
			while isnull(@IsAggiornaRec,0) = 1
			begin

				UPDATE @TabCG3RNumDoc
					SET NUMDOCAGG = CG3R.CG3R_NUMDOCAGG
				FROM (SELECT CG3R.ID AS CG3R_ID,
							(SELECT TOP 1 LETTERA
							 FROM @TabAlphabet
							 WHERE LETTERA NOT IN (SELECT DISTINCT CG3R_2.NUMDOCAGG
												   FROM @TabCG3RNumDoc AS CG3R_2
												   WHERE CG3R_2.NUMDOC = CG3R.NUMDOC
													 AND CG3R_2.NUMDOCAGG IS NOT NULL
												  )
							 ORDER BY ID
							) AS CG3R_NUMDOCAGG
					  FROM (SELECT CG3R.ID, CG3R.DITTACOLL, CG3R.MESE, CG3R.INDPERIODO, CG3R.NUMDOC, CG3R.NUMDOCAGG, CG3R.ID_CG3T,
								   DENSE_RANK() OVER(ORDER BY CG3R.DITTA, CG3R.ANNO, CG3R.MESE, CG3R.INDPERIODO, CG3R.INDPROV, CG3R.INDTIPOINVIO, CG3R.INDTIPOREC, CG3R.DITTACOLL, CG3R.TIPOCF, CG3R.CLIFOR, CG3R.CODICE_CG16, CG3R.ANAGRAPPFISC_CG16, CG3R.ANAGSTABORG_CG16, CG3R.NUMREG, CG3R.INDTIPODOC, CG3R.DATADOC, CG3R.NUMDOC, CG3R.DATAREG ASC) AS NUMRIGA
							FROM @TabCG3RNumDoc AS CG3R
							WHERE CG3R.MESE = @Mese
							  AND CG3R.INDPERIODO = @IndPeriodo
							  AND CG3R.NUMDOCAGG IS NULL
							  AND CG3R.ID_CG3T IS NULL
							) AS CG3R
						WHERE CG3R.NUMRIGA = 1
					) AS CG3R
				WHERE ID = CG3R.CG3R_ID

				set @IsAggiornaRec = (SELECT TOP 1 1
									  FROM @TabCG3RNumDoc AS CG3R
									  WHERE CG3R.MESE = @Mese
										AND CG3R.INDPERIODO = @IndPeriodo
										AND CG3R.NUMDOCAGG IS NULL
										AND CG3R.ID_CG3T IS NULL
									  )
			end

			UPDATE CG3R_DATIFATTURE
				SET CG3R_NUMDOCAGG = NUMDOCAGG
			FROM @TabCG3RNumDoc
			WHERE ID = CG3R_ID
			  AND CG3R_MESE = @Mese
			  AND CG3R_INDPERIODO = @IndPeriodo
			  AND CG3R_NUMDOCAGG IS NULL
			  AND CG3R_ID_CG3T IS NULL
		end
	end
	
	/* Aggiornamento numero documento multiattivit */
	if isnull(@InserisciLetteraMultiAtt,0) = 1
	begin
		
		set @IndTipoRec = 1

		DECLARE @TabCG3RNumDocMultiAtt TABLE (DITTACOLL			DECIMAL(5),
											  MESE				TINYINT,
											  INDPERIODO		TINYINT,
											  SEZIONALE			CHAR(2) COLLATE DATABASE_DEFAULT,
											  NUMDOCAGGMULTIATT	NVARCHAR(20) COLLATE DATABASE_DEFAULT,
											  ID_CG3T			BIGINT)

		INSERT INTO @TabCG3RNumDocMultiAtt (DITTACOLL, MESE, INDPERIODO, SEZIONALE, NUMDOCAGGMULTIATT, ID_CG3T)
			SELECT CG3R.CG3R_DITTACOLL_CG18, CG3R.CG3R_MESE, CG3R.CG3R_INDPERIODO, CG41.CG41_SEZIONALE, CG3R.CG3R_NUMDOCAGGMULTIATT, CG3R.CG3R_ID_CG3T
			FROM CG3R_DATIFATTURE AS CG3R WITH(NOLOCK)
			INNER JOIN CG41_PRIMANOTA AS CG41 WITH(NOLOCK)
			   ON CG41_DITTA_CG18 = CG3R.CG3R_DITTACOLL_CG18
			  AND CG41_NUMREG = CG3R.CG3R_NUMREG_CO99
			WHERE CG3R.CG3R_DITTA_CG18 = @CodiceDitta
				AND CG3R.CG3R_ANNO = @Anno
				AND CG3R.CG3R_INDPROV = @IndProv
				AND CG3R.CG3R_INDTIPOINVIO IN (0,1,2) --Elaborato, Generato, Inviato
				AND CG3R.CG3R_INDTIPOREC = @IndTipoRec
			GROUP BY CG3R.CG3R_DITTACOLL_CG18, CG3R.CG3R_MESE, CG3R.CG3R_INDPERIODO, CG41.CG41_SEZIONALE, CG3R.CG3R_NUMDOCAGGMULTIATT, CG3R.CG3R_ID_CG3T

		DELETE
		FROM @TabCG3RNumDocMultiAtt
		WHERE SEZIONALE IN (SELECT SEZ.SEZIONALE
							FROM (SELECT CG3R.DITTACOLL, CG3R.SEZIONALE
								  FROM @TabCG3RNumDocMultiAtt AS CG3R
								  GROUP BY CG3R.DITTACOLL, CG3R.SEZIONALE
								 ) AS SEZ
							GROUP BY SEZ.SEZIONALE
							HAVING COUNT(1) = 1
						   )

		/* Determina se esistono record del telematico da aggiornare con il numero documento aggiuntivo */
		set @IsAggiornaRec = (SELECT TOP 1 1
							  FROM @TabCG3RNumDocMultiAtt AS CG3R
							  WHERE CG3R.MESE = @Mese
								AND CG3R.INDPERIODO = @IndPeriodo
								AND CG3R.NUMDOCAGGMULTIATT IS NULL
								AND CG3R.ID_CG3T IS NULL
							  )

		if isnull(@IsAggiornaRec,0) = 1
		begin

			/* Ciclo fino a quando non ho aggiornato tutti i record del telematico con il numero documento aggiuntivo */
			while isnull(@IsAggiornaRec,0) = 1
			begin

				UPDATE @TabCG3RNumDocMultiAtt
					SET NUMDOCAGGMULTIATT = CG3R.CG3R_NUMDOCAGGMULTIATT
				FROM (SELECT CG3R.DITTACOLL AS CG3R_DITTACOLL_CG18,
							 CG3R.SEZIONALE AS CG41_SEZIONALE,
							 ISNULL((SELECT TOP 1 CG3R_2.NUMDOCAGGMULTIATT
									 FROM @TabCG3RNumDocMultiAtt AS CG3R_2
									 WHERE CG3R_2.DITTACOLL = CG3R.DITTACOLL
									   AND CG3R_2.NUMDOCAGGMULTIATT IS NOT NULL),
									 (SELECT TOP 1 LETTERA
									  FROM (SELECT ID, LETTERA
											FROM @TabAlphabet
											WHERE ID = 1											  
											  AND CG3R.DITTACOLL = @CodiceDitta
											UNION ALL
											SELECT ID, LETTERA
										    FROM @TabAlphabet
											WHERE ID > 1
										   ) AS TABALPHABET
									  WHERE LETTERA NOT IN (SELECT DISTINCT CG3R_2.NUMDOCAGGMULTIATT
										  			        FROM @TabCG3RNumDocMultiAtt AS CG3R_2
															WHERE CG3R_2.NUMDOCAGGMULTIATT IS NOT NULL
														   )
									  ORDER BY ID
									)) AS CG3R_NUMDOCAGGMULTIATT
					  FROM (SELECT CG3R.DITTACOLL, CG3R.MESE, CG3R.INDPERIODO, CG3R.SEZIONALE, CG3R.NUMDOCAGGMULTIATT, CG3R.ID_CG3T,
								   DENSE_RANK() OVER(ORDER BY CG3R.DITTACOLL ASC) AS NUMRIGA
							FROM @TabCG3RNumDocMultiAtt AS CG3R
							WHERE CG3R.MESE = @Mese
							  AND CG3R.INDPERIODO = @IndPeriodo
							  AND CG3R.NUMDOCAGGMULTIATT IS NULL
							  AND CG3R.ID_CG3T IS NULL
							) AS CG3R
						WHERE CG3R.NUMRIGA = 1
					) AS CG3R
				WHERE DITTACOLL = CG3R.CG3R_DITTACOLL_CG18
				  AND SEZIONALE = CG3R.CG41_SEZIONALE
				  AND MESE = @Mese
				  AND INDPERIODO = @IndPeriodo
				  AND NUMDOCAGGMULTIATT IS NULL
				  AND ID_CG3T IS NULL

				set @IsAggiornaRec = (SELECT TOP 1 1
									  FROM @TabCG3RNumDocMultiAtt AS CG3R
									  WHERE CG3R.MESE = @Mese
										AND CG3R.INDPERIODO = @IndPeriodo
										AND CG3R.NUMDOCAGGMULTIATT IS NULL
										AND CG3R.ID_CG3T IS NULL
									  )
			end

			UPDATE CG3R_DATIFATTURE
				SET CG3R_NUMDOCAGGMULTIATT = NUMDOCAGGMULTIATT
			FROM CG3R_DATIFATTURE
			INNER JOIN (SELECT CG3R_ID AS ID, NUMDOCAGGMULTIATT
						FROM CG3R_DATIFATTURE WITH(NOLOCK)
						INNER JOIN CG41_PRIMANOTA AS CG41 WITH(NOLOCK)
						   ON CG41_DITTA_CG18 = CG3R_DITTACOLL_CG18
						  AND CG41_NUMREG = CG3R_NUMREG_CO99
						INNER JOIN @TabCG3RNumDocMultiAtt AS CG3R
						   ON CG3R.DITTACOLL = CG3R_DITTACOLL_CG18
						  AND CG3R.SEZIONALE = CG41_SEZIONALE
						  AND CG3R.NUMDOCAGGMULTIATT IS NOT NULL
						WHERE CG3R_DITTA_CG18 = @CodiceDitta
						  AND CG3R_ANNO = @Anno
						  AND CG3R_INDPROV = @IndProv
						  AND CG3R_INDTIPOINVIO IN (0,1,2) --Elaborato, Generato, Inviato
						  AND CG3R_INDTIPOREC = @IndTipoRec
						  AND CG3R_MESE = @Mese
						  AND CG3R_INDPERIODO = @IndPeriodo
						  AND CG3R_NUMDOCAGGMULTIATT IS NULL
						  AND CG3R_ID_CG3T IS NULL
					   ) AS MOVSEZ
			   ON ID = CG3R_ID
					  
		end		
	end

			
	/******************
	*  GESTIONE FILE  *
	*******************/

	/* Determina l'ID della comunicazione */
	SELECT TOP 1 @CG3Q_ID = CG3Q_ID
	FROM CG3Q_INVIIDATIFATT WITH(NOLOCK)
	WHERE CG3Q_DITTA_CG18 = @CodDittaPrincipale
		AND CG3Q_ANNO = @Anno
		AND CG3Q_MESE = @Mese
		AND CG3Q_INDPERIODO = @IndPeriodo
	ORDER BY CG3Q_ID

	if isnull(@CG3Q_ID,0) > 0
	begin

		/* Determina il nuovo progressivo flusso di invio da inserire relativo alla comunicazione */
		SELECT @CG3S_PROGFLUSSO = ISNULL(MAX(CG3S_PROGFLUSSO),0) + 1
		FROM CG3S_FLUSSIDATIFATT WITH(NOLOCK)
		WHERE CG3S_ID_CG3Q = @CG3Q_ID

		if isnull(@CG3S_PROGFLUSSO,0) > 0 
		begin

			/* Inserisce il nuovo progressivo flusso di invio */
			INSERT INTO CG3S_FLUSSIDATIFATT (CG3S_ID_CG3Q, CG3S_PROGFLUSSO)
				VALUES (@CG3Q_ID, @CG3S_PROGFLUSSO)

			/* Determina l'ID flusso di invio appena inserito */
			SELECT TOP 1 @CG3S_ID = CG3S_ID
			FROM CG3S_FLUSSIDATIFATT WITH(NOLOCK)
			WHERE CG3S_ID_CG3Q = @CG3Q_ID
				AND CG3S_PROGFLUSSO = @CG3S_PROGFLUSSO
			ORDER BY CG3S_ID

			if isnull(@CG3S_ID,0) > 0
			begin
					
				set @IndTipoRec = 1
				while isnull(@IndTipoRec,0) <= 2
				begin

					/* Determina se esistono record del telematico da aggiornare con l'ID file */
					set @IsAggiornaRec = (SELECT TOP 1 1
										  FROM CG3R_DATIFATTURE WITH(NOLOCK)
										  WHERE CG3R_DITTA_CG18 = @CodDittaPrincipale
											AND CG3R_ANNO = @Anno
											AND CG3R_MESE = @Mese
											AND CG3R_INDPERIODO = @IndPeriodo
											AND CG3R_INDPROV = @IndProv
											AND CG3R_INDTIPOREC = @IndTipoRec
											AND CG3R_ID_CG3T IS NULL
											)

					/* Ciclo fino a quando non ho aggiornato tutti i record del telematico con l'ID file */
					while isnull(@IsAggiornaRec,0) = 1
					begin

						set @IsAggiornaRec = 0
						set @CG3T_PROGFILE = 0
						set @CG3T_ID = 0

						/* Determina il nuovo progressivo file da inserire relativo al flusso */
						SELECT @CG3T_PROGFILE = ISNULL(MAX(CG3T_PROGFILE),0) + 1
						FROM CG3T_FILEDATIFATT WITH(NOLOCK)
						WHERE CG3T_ID_CG3S = @CG3S_ID
		
						if isnull(@CG3T_PROGFILE,0) > 0 
						begin

							/* Inserisce il nuovo progressivo file */
							INSERT INTO CG3T_FILEDATIFATT (CG3T_ID_CG3S, CG3T_PROGFILE)
								VALUES (@CG3S_ID, @CG3T_PROGFILE)

							/* Determina l'ID file appena inserito */
							SELECT TOP 1 @CG3T_ID = CG3T_ID
							FROM CG3T_FILEDATIFATT WITH(NOLOCK)
							WHERE CG3T_ID_CG3S = @CG3S_ID
								AND CG3T_PROGFILE = @CG3T_PROGFILE
							ORDER BY CG3T_ID

							if isnull(@CG3T_ID,0) > 0
							begin

								/* Aggiorno l'ID file sui record del telematico*/
								UPDATE CG3R_DATIFATTURE
								   SET CG3R_ID_CG3T = @CG3T_ID
								FROM CG3R_DATIFATTURE AS CG3R WITH(NOLOCK)
								INNER JOIN (SELECT *
											FROM (SELECT *,
														 DENSE_RANK() OVER (ORDER BY CG3R_DITTA_CG18, CG3R_ANNO, CG3R_MESE, CG3R_INDPERIODO, CG3R_INDPROV, CG3R_INDTIPOINVIO, CG3R_INDTIPOREC, PARTITAIVA, CODFISCALE, CG16_RAGSOANAG, CG3R_CODICE_CG16, CG3R_ANAGRAPPFISC_CG16, CG3R_ANAGSTABORG_CG16, CASE WHEN CG3R_INDTIPODOC = 12 THEN 1 ELSE 0 END) AS PROG_CF,
														 ROW_NUMBER() OVER (PARTITION BY CG3R_DITTA_CG18, CG3R_ANNO, CG3R_MESE, CG3R_INDPERIODO, CG3R_INDPROV, CG3R_INDTIPOINVIO, CG3R_INDTIPOREC, PARTITAIVA, CODFISCALE, CG16_RAGSOANAG, CG3R_CODICE_CG16, CG3R_ANAGRAPPFISC_CG16, CG3R_ANAGSTABORG_CG16, CASE WHEN CG3R_INDTIPODOC = 12 THEN 1 ELSE 0 END
														 				    ORDER BY CG3R_DITTA_CG18, CG3R_ANNO, CG3R_MESE, CG3R_INDPERIODO, CG3R_INDPROV, CG3R_INDTIPOINVIO, CG3R_INDTIPOREC, PARTITAIVA, CODFISCALE, CG16_RAGSOANAG, CG3R_CODICE_CG16, CG3R_ANAGRAPPFISC_CG16, CG3R_ANAGSTABORG_CG16, CASE WHEN CG3R_INDTIPODOC = 12 THEN 1 ELSE 0 END, CG3R_DATADOC, CG3R_NUMDOC, CG3R_DATAREG, CG3R_INDTIPODOC, CG3R_DITTACOLL_CG18, CG3R_NUMREG_CO99) AS PROG_FATT_CF,
														 ROW_NUMBER() OVER (PARTITION BY CG3R_DITTA_CG18, CG3R_ANNO, CG3R_MESE, CG3R_INDPERIODO, CG3R_INDPROV, CG3R_INDTIPOINVIO, CG3R_INDTIPOREC
														 				    ORDER BY CG3R_DITTA_CG18, CG3R_ANNO, CG3R_MESE, CG3R_INDPERIODO, CG3R_INDPROV, CG3R_INDTIPOINVIO, CG3R_INDTIPOREC, PARTITAIVA, CODFISCALE, CG16_RAGSOANAG, CG3R_CODICE_CG16, CG3R_ANAGRAPPFISC_CG16, CG3R_ANAGSTABORG_CG16, CASE WHEN CG3R_INDTIPODOC = 12 THEN 1 ELSE 0 END, CG3R_DATADOC, CG3R_NUMDOC, CG3R_DATAREG, CG3R_INDTIPODOC, CG3R_DITTACOLL_CG18, CG3R_NUMREG_CO99) AS PROG_FATT_TOT
												  FROM (SELECT *
														FROM (SELECT CG3R_DITTA_CG18, CG3R_ANNO, CG3R_MESE, CG3R_INDPERIODO, CG3R_INDPROV, CG3R_INDTIPOINVIO, CG3R_INDTIPOREC, 
															         CASE CG3R_INDTIPOREC
																		  WHEN 1 THEN CASE WHEN LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.PARTIVA,''))) = '' AND ISNULL(CG07_TABSTATIEST.CG07_A2ISO3166, ISNULL(CG07_TABSTATIEST.CG07_CODISO,'IT')) <> 'IT' THEN LEFT(CAST(VCG16_ANAGGEN.CG16_CODICE AS NVARCHAR(10)) + ' ' + ISNULL(VCG16_ANAGGEN.RAGSOANAGPF,''),28) ELSE VCG16_ANAGGEN.PARTIVA END
															              WHEN 2 THEN CASE WHEN LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.PARTIVA,''))) = '' AND ISNULL(CG07_TABSTATIEST.CG07_INDTIPOSTATO, -1) = 0 THEN LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.CG16_PARTIVA_EST,''))) ELSE LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.PARTIVA,''))) END
															              ELSE NULL
															              END AS PARTITAIVA,
																	 CASE WHEN ISNULL(CG07_TABSTATIEST.CG07_A2ISO3166, ISNULL(CG07_TABSTATIEST.CG07_CODISO,'IT')) = 'IT' THEN VCG16_ANAGGEN.CG16_CODFISCALE ELSE NULL END AS CODFISCALE,
															         CASE WHEN CG3R_INDTIPODOC IN (7,8) AND LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.PARTIVA,''))) = '' AND LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.CG16_CODFISCALE,''))) = ''
															              THEN LEFT(ISNULL(VCG16_ANAGGEN.RAGSOANAGPF,''),80)
															              ELSE CASE WHEN ISNULL(VCG16_ANAGGEN.RAGSOANAGPF,'') <> ''
															                        THEN LEFT(ISNULL(VCG16_ANAGGEN.RAGSOANAGPF,''),80)
															                        ELSE ''
															                        END
															              END AS CG16_RAGSOANAG,
																	 CG3R_CODICE_CG16, CG3R_ANAGRAPPFISC_CG16, CG3R_ANAGSTABORG_CG16,
																	 CG3R_DATADOC, RIGHT(ISNULL(CG3R_NUMDOC,'') + ISNULL(CG3R_NUMDOCAGGMULTIATT,'') + ISNULL(CG3R_NUMDOCAGG,''),20) AS CG3R_NUMDOC, CG3R_DATAREG, CG3R_INDTIPODOC, CG3R_DITTACOLL_CG18, CG3R_NUMREG_CO99
															  FROM CG3R_DATIFATTURE WITH(NOLOCK)
															  LEFT OUTER JOIN VCG16_DATIFATTURE AS VCG16_ANAGGEN
  																ON VCG16_ANAGGEN.CG16_CODICE = CG3R_CODICE_CG16
															   AND @DataFineComunicazione >= ISNULL(VCG16_ANAGGEN.DATAINIZIOVALIDITA, '17530101')
															   AND @DataFineComunicazione <= ISNULL(VCG16_ANAGGEN.DATAFINEVALIDITA, '99991231')
															  OUTER APPLY dbo.FNCG07_TABSTATIEST(VCG16_ANAGGEN.CG16_CODICE_CG07, CG3R_DATIFATTURE.CG3R_DITTA_CG18) AS CG07_TABSTATIEST
															  WHERE CG3R_DITTA_CG18 = @CodDittaPrincipale
																AND CG3R_ANNO = @Anno
																AND CG3R_MESE = @Mese
																AND CG3R_INDPERIODO = @IndPeriodo
																AND CG3R_INDPROV = @IndProv
																AND CG3R_INDTIPOREC = @IndTipoRec
																AND CG3R_ID_CG3T IS NULL
															 ) AS CG3R_PROG
															 GROUP BY CG3R_DITTA_CG18, CG3R_ANNO, CG3R_MESE, CG3R_INDPERIODO, CG3R_INDPROV, CG3R_INDTIPOINVIO, CG3R_INDTIPOREC, PARTITAIVA, CODFISCALE, CG16_RAGSOANAG, CG3R_CODICE_CG16, CG3R_ANAGRAPPFISC_CG16, CG3R_ANAGSTABORG_CG16, CG3R_DATADOC, CG3R_NUMDOC, CG3R_DATAREG, CG3R_INDTIPODOC, CG3R_DITTACOLL_CG18, CG3R_NUMREG_CO99
													   ) AS CG3R_PROG
												) AS CG3R_PROG
												WHERE PROG_CF <= @MaxCliFor
													AND PROG_FATT_CF <= @MaxFattureCF
													AND PROG_FATT_TOT <= @MaxFattureFile
											) AS CG3R_PROG
									ON CG3R_PROG.CG3R_DITTA_CG18 = CG3R.CG3R_DITTA_CG18
									AND CG3R_PROG.CG3R_ANNO = CG3R.CG3R_ANNO
									AND CG3R_PROG.CG3R_MESE = CG3R.CG3R_MESE
									AND CG3R_PROG.CG3R_INDPERIODO = CG3R.CG3R_INDPERIODO
									AND CG3R_PROG.CG3R_INDPROV = CG3R.CG3R_INDPROV
									AND CG3R_PROG.CG3R_INDTIPOINVIO = CG3R.CG3R_INDTIPOINVIO
									AND CG3R_PROG.CG3R_INDTIPOREC = CG3R.CG3R_INDTIPOREC
									AND ISNULL(CG3R_PROG.CG3R_CODICE_CG16,0) = ISNULL(CG3R.CG3R_CODICE_CG16,0)
									AND ISNULL(CG3R_PROG.CG3R_ANAGRAPPFISC_CG16,0) = ISNULL(CG3R.CG3R_ANAGRAPPFISC_CG16,0)
									AND ISNULL(CG3R_PROG.CG3R_ANAGSTABORG_CG16,0) = ISNULL(CG3R.CG3R_ANAGSTABORG_CG16,0)
									AND ISNULL(CG3R_PROG.CG3R_DATADOC,'99991231') = ISNULL(CG3R.CG3R_DATADOC,'99991231')
									AND ISNULL(CG3R_PROG.CG3R_NUMDOC,'') = RIGHT(ISNULL(CG3R.CG3R_NUMDOC,'') + ISNULL(CG3R.CG3R_NUMDOCAGGMULTIATT,'') + ISNULL(CG3R.CG3R_NUMDOCAGG,''),20)
									AND ISNULL(CG3R_PROG.CG3R_DATAREG,'99991231') = ISNULL(CG3R.CG3R_DATAREG,'99991231')
									AND ISNULL(CG3R_PROG.CG3R_INDTIPODOC,0) = ISNULL(CG3R.CG3R_INDTIPODOC,0)
									AND ISNULL(CG3R_PROG.CG3R_DITTACOLL_CG18,0) = ISNULL(CG3R.CG3R_DITTACOLL_CG18,0)
									AND ISNULL(CG3R_PROG.CG3R_NUMREG_CO99,'') = ISNULL(CG3R.CG3R_NUMREG_CO99,'')


								/* Aggiorno il progressivo per fattura sui record del telematico relativi all'ID file appena aggiornato*/
								UPDATE CG3R_DATIFATTURE
								   SET CG3R_PROGFATT = PROG_FATT
								FROM CG3R_DATIFATTURE AS CG3R WITH(NOLOCK)
								INNER JOIN (SELECT *
											FROM (SELECT *,
														 ROW_NUMBER() OVER (ORDER BY CG3R_DITTA_CG18, CG3R_ANNO, CG3R_MESE, CG3R_INDPERIODO, CG3R_INDPROV, CG3R_INDTIPOINVIO, CG3R_INDTIPOREC, PARTITAIVA, CODFISCALE, CG16_RAGSOANAG, CG3R_CODICE_CG16, CG3R_ANAGRAPPFISC_CG16, CG3R_ANAGSTABORG_CG16, CASE WHEN CG3R_INDTIPODOC = 12 THEN 1 ELSE 0 END, CG3R_DATADOC, CG3R_NUMDOC, CG3R_DATAREG, CG3R_INDTIPODOC, CG3R_DITTACOLL_CG18, CG3R_NUMREG_CO99) AS PROG_FATT
												  FROM (SELECT *
														FROM (SELECT CG3R_DITTA_CG18, CG3R_ANNO, CG3R_MESE, CG3R_INDPERIODO, CG3R_INDPROV, CG3R_INDTIPOINVIO, CG3R_INDTIPOREC, 
															         CASE CG3R_INDTIPOREC
																		  WHEN 1 THEN CASE WHEN LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.PARTIVA,''))) = '' AND ISNULL(CG07_TABSTATIEST.CG07_A2ISO3166, ISNULL(CG07_TABSTATIEST.CG07_CODISO,'IT')) <> 'IT' THEN LEFT(CAST(VCG16_ANAGGEN.CG16_CODICE AS NVARCHAR(10)) + ' ' + ISNULL(VCG16_ANAGGEN.RAGSOANAGPF,''),28) ELSE VCG16_ANAGGEN.PARTIVA END
															              WHEN 2 THEN CASE WHEN LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.PARTIVA,''))) = '' AND ISNULL(CG07_TABSTATIEST.CG07_INDTIPOSTATO, -1) = 0 THEN LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.CG16_PARTIVA_EST,''))) ELSE LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.PARTIVA,''))) END
															              ELSE NULL
															              END AS PARTITAIVA,
																	 CASE WHEN ISNULL(CG07_TABSTATIEST.CG07_A2ISO3166, ISNULL(CG07_TABSTATIEST.CG07_CODISO,'IT')) = 'IT' THEN VCG16_ANAGGEN.CG16_CODFISCALE ELSE NULL END AS CODFISCALE,
															         CASE WHEN CG3R_INDTIPODOC IN (7,8) AND LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.PARTIVA,''))) = '' AND LTRIM(RTRIM(ISNULL(VCG16_ANAGGEN.CG16_CODFISCALE,''))) = ''
															              THEN LEFT(ISNULL(VCG16_ANAGGEN.RAGSOANAGPF,''),80)
															              ELSE CASE WHEN ISNULL(VCG16_ANAGGEN.RAGSOANAGPF,'') <> ''
															                        THEN LEFT(ISNULL(VCG16_ANAGGEN.RAGSOANAGPF,''),80)
															                        ELSE ''
															                        END
															              END AS CG16_RAGSOANAG,
																	 CG3R_CODICE_CG16, CG3R_ANAGRAPPFISC_CG16, CG3R_ANAGSTABORG_CG16,
																	 CG3R_DATADOC, RIGHT(ISNULL(CG3R_NUMDOC,'') + ISNULL(CG3R_NUMDOCAGGMULTIATT,'') + ISNULL(CG3R_NUMDOCAGG,''),20) AS CG3R_NUMDOC, CG3R_DATAREG, CG3R_INDTIPODOC, CG3R_DITTACOLL_CG18, CG3R_NUMREG_CO99
															  FROM CG3R_DATIFATTURE WITH(NOLOCK)
															  LEFT OUTER JOIN VCG16_DATIFATTURE AS VCG16_ANAGGEN
  																ON VCG16_ANAGGEN.CG16_CODICE = CG3R_CODICE_CG16
															   AND @DataFineComunicazione >= ISNULL(VCG16_ANAGGEN.DATAINIZIOVALIDITA, '17530101')
															   AND @DataFineComunicazione <= ISNULL(VCG16_ANAGGEN.DATAFINEVALIDITA, '99991231')
															  OUTER APPLY dbo.FNCG07_TABSTATIEST(VCG16_ANAGGEN.CG16_CODICE_CG07, CG3R_DATIFATTURE.CG3R_DITTA_CG18) AS CG07_TABSTATIEST
															  WHERE CG3R_ID_CG3T = @CG3T_ID
															 ) AS CG3R_PROG
															 GROUP BY CG3R_DITTA_CG18, CG3R_ANNO, CG3R_MESE, CG3R_INDPERIODO, CG3R_INDPROV, CG3R_INDTIPOINVIO, CG3R_INDTIPOREC, PARTITAIVA, CODFISCALE, CG16_RAGSOANAG, CG3R_CODICE_CG16, CG3R_ANAGRAPPFISC_CG16, CG3R_ANAGSTABORG_CG16, CG3R_DATADOC, CG3R_NUMDOC, CG3R_DATAREG, CG3R_INDTIPODOC, CG3R_DITTACOLL_CG18, CG3R_NUMREG_CO99
													   ) AS CG3R_PROG
												) AS CG3R_PROG
											) AS CG3R_PROG
									ON CG3R_PROG.CG3R_DITTA_CG18 = CG3R.CG3R_DITTA_CG18
									AND CG3R_PROG.CG3R_ANNO = CG3R.CG3R_ANNO
									AND CG3R_PROG.CG3R_MESE = CG3R.CG3R_MESE
									AND CG3R_PROG.CG3R_INDPERIODO = CG3R.CG3R_INDPERIODO
									AND CG3R_PROG.CG3R_INDPROV = CG3R.CG3R_INDPROV
									AND CG3R_PROG.CG3R_INDTIPOINVIO = CG3R.CG3R_INDTIPOINVIO
									AND CG3R_PROG.CG3R_INDTIPOREC = CG3R.CG3R_INDTIPOREC
									AND ISNULL(CG3R_PROG.CG3R_CODICE_CG16,0) = ISNULL(CG3R.CG3R_CODICE_CG16,0)
									AND ISNULL(CG3R_PROG.CG3R_ANAGRAPPFISC_CG16,0) = ISNULL(CG3R.CG3R_ANAGRAPPFISC_CG16,0)
									AND ISNULL(CG3R_PROG.CG3R_ANAGSTABORG_CG16,0) = ISNULL(CG3R.CG3R_ANAGSTABORG_CG16,0)
									AND ISNULL(CG3R_PROG.CG3R_DATADOC,'99991231') = ISNULL(CG3R.CG3R_DATADOC,'99991231')
									AND ISNULL(CG3R_PROG.CG3R_NUMDOC,'') = RIGHT(ISNULL(CG3R.CG3R_NUMDOC,'') + ISNULL(CG3R.CG3R_NUMDOCAGGMULTIATT,'') + ISNULL(CG3R.CG3R_NUMDOCAGG,''),20)
									AND ISNULL(CG3R_PROG.CG3R_DATAREG,'99991231') = ISNULL(CG3R.CG3R_DATAREG,'99991231')
									AND ISNULL(CG3R_PROG.CG3R_INDTIPODOC,0) = ISNULL(CG3R.CG3R_INDTIPODOC,0)
									AND ISNULL(CG3R_PROG.CG3R_DITTACOLL_CG18,0) = ISNULL(CG3R.CG3R_DITTACOLL_CG18,0)
									AND ISNULL(CG3R_PROG.CG3R_NUMREG_CO99,'') = ISNULL(CG3R.CG3R_NUMREG_CO99,'')


								/* Aggiorno il progressivo per riga sui record del telematico relativi all'ID file appena aggiornato*/
								UPDATE CG3R_DATIFATTURE
									SET CG3R_PROGRIGA = PROG_RIGA
								FROM CG3R_DATIFATTURE AS CG3R WITH(NOLOCK)
								INNER JOIN (SELECT CG3R_ID,
												   ROW_NUMBER() OVER (ORDER BY CG3R_ID) AS PROG_RIGA
											FROM CG3R_DATIFATTURE WITH(NOLOCK)
											WHERE CG3R_ID_CG3T = @CG3T_ID
										   ) AS CG3R_RIGA
								ON CG3R_RIGA.CG3R_ID = CG3R.CG3R_ID


								/* Ciclo fino a quando non ho aggiornato tutti i record del telematico con l'ID file */
								set @IsAggiornaRec = (SELECT TOP 1 1
													  FROM CG3R_DATIFATTURE WITH(NOLOCK)
													  WHERE CG3R_DITTA_CG18 = @CodDittaPrincipale
														AND CG3R_ANNO = @Anno
														AND CG3R_MESE = @Mese
														AND CG3R_INDPERIODO = @IndPeriodo
														AND CG3R_INDPROV = @IndProv
														AND CG3R_INDTIPOREC = @IndTipoRec
														AND CG3R_ID_CG3T IS NULL
														)
							end
						end
					end
					set @IndTipoRec = isnull(@IndTipoRec,0) + 1
				end
			end
		end
	end

END
